/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment;

import io.quarkiverse.roq.frontmatter.runtime.RoqTemplateExtension;
import io.quarkiverse.roq.frontmatter.runtime.model.PageInfo;
import io.quarkiverse.roq.util.PathUtils;
import io.vertx.core.json.JsonObject;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class TemplateLink {
    public static final String DEFAULT_PAGE_LINK_TEMPLATE = "/:path:ext";
    public static final String DEFAULT_DOC_LINK_TEMPLATE = "/:collection/:slug/";
    public static final String DEFAULT_PAGINATE_LINK_TEMPLATE = "/:collection/page:page/";
    private static final DateTimeFormatter YEAR_FORMAT = DateTimeFormatter.ofPattern("yyyy");
    private static final DateTimeFormatter MONTH_FORMAT = DateTimeFormatter.ofPattern("MM");
    private static final DateTimeFormatter DAY_FORMAT = DateTimeFormatter.ofPattern("dd");

    private static Map<String, Supplier<String>> withBasePlaceHolders(LinkData data, Map<String, Supplier<String>> other) {
        Map.Entry[] entryArray = new Map.Entry[8];
        entryArray[0] = Map.entry(":collection", data::collection);
        entryArray[1] = Map.entry(":year", () -> Optional.ofNullable(data.pageInfo().date()).orElse(ZonedDateTime.now()).format(YEAR_FORMAT));
        entryArray[2] = Map.entry(":month", () -> Optional.ofNullable(data.pageInfo().date()).orElse(ZonedDateTime.now()).format(MONTH_FORMAT));
        entryArray[3] = Map.entry(":day", () -> Optional.ofNullable(data.pageInfo().date()).orElse(ZonedDateTime.now()).format(DAY_FORMAT));
        entryArray[4] = Map.entry(":path", () -> PathUtils.slugify((String)PathUtils.removeExtension((String)data.pageInfo().sourceFilePath()), (boolean)true, (boolean)false).toLowerCase());
        entryArray[5] = Map.entry(":ext", () -> data.pageInfo().isHtml() ? "" : "." + data.pageInfo().sourceFileExtension());
        entryArray[6] = Map.entry(":ext!", () -> data.pageInfo().isHtml() ? ".html" : "." + data.pageInfo().sourceFileExtension());
        entryArray[7] = Map.entry(":slug", () -> TemplateLink.resolveSlug(data));
        HashMap<String, Supplier<String>> result = new HashMap<String, Supplier<String>>(Map.ofEntries(entryArray));
        if (other != null) {
            result.putAll(other);
        }
        return result;
    }

    public static String resolveSlug(LinkData data) {
        String title = data.data().getString("slug", data.data().getString("title"));
        if (title == null || title.isBlank()) {
            String baseFileName = data.pageInfo().sourceBaseFileName();
            title = "index".equalsIgnoreCase(baseFileName) ? PathUtils.fileName((String)data.pageInfo().sourceFilePath().replaceAll("/index\\..+", "")) : baseFileName;
        }
        return RoqTemplateExtension.slugify((String)title).toLowerCase();
    }

    public static String pageLink(String rootPath, String template, PageLinkData data) {
        return TemplateLink.link(rootPath, template, data.collection == null ? DEFAULT_PAGE_LINK_TEMPLATE : DEFAULT_DOC_LINK_TEMPLATE, TemplateLink.withBasePlaceHolders(data, null));
    }

    public static String paginateLink(String rootPath, String template, PaginateLinkData data) {
        return TemplateLink.link(rootPath, template, DEFAULT_PAGINATE_LINK_TEMPLATE, TemplateLink.withBasePlaceHolders(data, Map.of(":page", () -> Objects.requireNonNull(data.page(), "page index is required to build the link"))));
    }

    public static String link(String rootPath, String template, String defaultTemplate, LinkData data, Map<String, Supplier<String>> placeHolders) {
        return TemplateLink.link(rootPath, template, defaultTemplate, TemplateLink.withBasePlaceHolders(data, placeHolders));
    }

    private static String link(String rootPath, String template, String defaultTemplate, Map<String, Supplier<String>> mapping) {
        String link = template != null ? template : defaultTemplate;
        for (Map.Entry<String, Supplier<String>> entry : mapping.entrySet()) {
            if (!link.contains(entry.getKey())) continue;
            String replacement = entry.getValue().get();
            link = link.replace(entry.getKey(), replacement);
        }
        if (link.endsWith("index") || link.endsWith("index.html")) {
            link = link.replaceAll("index(\\.html)?", "");
        }
        return PathUtils.addTrailingSlashIfNoExt((String)PathUtils.removeLeadingSlash((String)PathUtils.join((String)rootPath, (String)link)));
    }

    public static interface LinkData {
        public PageInfo pageInfo();

        public String collection();

        public JsonObject data();
    }

    public record PageLinkData(PageInfo pageInfo, String collection, JsonObject data) implements LinkData
    {
    }

    public record PaginateLinkData(PageInfo pageInfo, String collection, String page, JsonObject data) implements LinkData
    {
    }
}

