/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment.data;

import io.quarkiverse.roq.frontmatter.deployment.RoqFrontMatterRootUrlBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.TemplateLink;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterDocumentTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterPaginateTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqLayoutNotFoundException;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishPageBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterRawTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterScanProcessor;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterStaticFileBuildItem;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.RootUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RoqFrontMatterDataProcessor {
    public static final String LINK_KEY = "link";
    public static final String PAGINATE_KEY = "paginate";

    @BuildStep
    void prepareData(VertxHttpBuildTimeConfig httpConfig, RoqSiteConfig config, BuildProducer<RoqFrontMatterRootUrlBuildItem> rootUrlProducer, BuildProducer<RoqFrontMatterTemplateBuildItem> templatesProducer, List<RoqFrontMatterRawTemplateBuildItem> roqFrontMatterTemplates) {
        if (roqFrontMatterTemplates.isEmpty()) {
            return;
        }
        Map<String, RoqFrontMatterRawTemplateBuildItem> byId = roqFrontMatterTemplates.stream().filter(i -> !i.type().isPage()).collect(Collectors.toMap(RoqFrontMatterRawTemplateBuildItem::id, Function.identity(), (a, b) -> {
            throw new IllegalStateException("Multiple templates found with id '" + a.id() + "', this is a bug.");
        }));
        RootUrl rootUrl = new RootUrl(config.urlOptional().orElse(""), httpConfig.rootPath());
        rootUrlProducer.produce((BuildItem)new RoqFrontMatterRootUrlBuildItem(rootUrl));
        for (RoqFrontMatterRawTemplateBuildItem item : roqFrontMatterTemplates) {
            JsonObject data = RoqFrontMatterDataProcessor.mergeParents(config, item, byId);
            RoqUrl url = null;
            if (item.published()) {
                String link = TemplateLink.pageLink(config.rootPath(), data.getString(LINK_KEY), new TemplateLink.PageLinkData(item.info(), item.collectionId(), data));
                url = rootUrl.resolve(link);
            }
            RoqFrontMatterTemplateBuildItem templateItem = new RoqFrontMatterTemplateBuildItem(item, url, data);
            templatesProducer.produce((BuildItem)templateItem);
        }
    }

    @BuildStep
    void dispatchByType(BuildProducer<RoqFrontMatterPublishPageBuildItem> pagesProducer, BuildProducer<RoqFrontMatterDocumentTemplateBuildItem> documentTemplatesProducer, BuildProducer<RoqFrontMatterPaginateTemplateBuildItem> paginatedPagesProducer, BuildProducer<RoqFrontMatterStaticFileBuildItem> staticFileProducer, List<RoqFrontMatterTemplateBuildItem> templates) {
        if (templates.isEmpty()) {
            return;
        }
        for (RoqFrontMatterTemplateBuildItem item : templates) {
            if (!item.published()) continue;
            if (item.raw().attachments() != null) {
                for (RoqFrontMatterRawTemplateBuildItem.Attachment attachment : item.raw().attachments()) {
                    staticFileProducer.produce((BuildItem)new RoqFrontMatterStaticFileBuildItem(item.url().resolve((Object)attachment.name()).resourcePath(), attachment.path()));
                }
            }
            if (item.raw().collection() != null) {
                documentTemplatesProducer.produce((BuildItem)new RoqFrontMatterDocumentTemplateBuildItem(item.raw(), item.url(), item.raw().collection(), item.data()));
                continue;
            }
            if (item.data().containsKey(PAGINATE_KEY)) {
                paginatedPagesProducer.produce((BuildItem)new RoqFrontMatterPaginateTemplateBuildItem(item.url(), item.raw().info(), item.data(), null));
                continue;
            }
            pagesProducer.produce((BuildItem)new RoqFrontMatterPublishPageBuildItem(item.url(), item.raw().info(), item.data(), null));
        }
    }

    public static JsonObject mergeParents(RoqSiteConfig config, RoqFrontMatterRawTemplateBuildItem item, Map<String, RoqFrontMatterRawTemplateBuildItem> byId) {
        Stack<JsonObject> fms = new Stack<JsonObject>();
        String parent = item.layout();
        fms.add(item.data());
        while (parent != null) {
            if (!byId.containsKey(parent)) {
                String layoutKey = RoqFrontMatterScanProcessor.getLayoutKey(config.theme(), parent);
                throw new RoqLayoutNotFoundException("Layout '%s' not found for file '%s'. Available layouts are: %s.".formatted(layoutKey, item.info().sourceFilePath(), RoqFrontMatterDataProcessor.getAvailableLayouts(config, byId)));
            }
            RoqFrontMatterRawTemplateBuildItem parentItem = byId.get(parent);
            parent = parentItem.layout();
            fms.push(parentItem.data());
        }
        JsonObject merged = new JsonObject();
        while (!fms.empty()) {
            merged.mergeIn((JsonObject)fms.pop());
        }
        return merged;
    }

    private static String getAvailableLayouts(RoqSiteConfig config, Map<String, RoqFrontMatterRawTemplateBuildItem> byId) {
        return byId.entrySet().stream().filter(i -> ((RoqFrontMatterRawTemplateBuildItem)((Object)((Object)i.getValue()))).isLayout()).map(i -> RoqFrontMatterScanProcessor.getLayoutKey(config.theme(), (String)i.getKey())).map(arg_0 -> RoqFrontMatterDataProcessor.lambda$getAvailableLayouts$4("'%s'", arg_0)).collect(Collectors.joining(", "));
    }

    private static /* synthetic */ String lambda$getAvailableLayouts$4(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

