/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment.record;

import io.quarkiverse.roq.frontmatter.deployment.RoqFrontMatterOutputBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.RoqFrontMatterRootUrlBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqPathConflictException;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqSiteIndexNotFoundException;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishDerivedCollectionBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishDocumentPageBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishPageBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.record.RoqFrontMatterCollectionBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.record.RoqFrontMatterNormalPageBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.record.RoqFrontMatterPageBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.record.RoqFrontMatterSiteIndexBuildItem;
import io.quarkiverse.roq.frontmatter.runtime.RoqFrontMatterRecorder;
import io.quarkiverse.roq.frontmatter.runtime.config.ConfiguredCollection;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class RoqFrontMatterInitProcessor {
    private static final Logger LOGGER = Logger.getLogger(RoqFrontMatterInitProcessor.class);

    RoqFrontMatterInitProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void bindCollections(RoqFrontMatterRootUrlBuildItem rootUrlItem, List<RoqFrontMatterPublishDocumentPageBuildItem> documents, List<RoqFrontMatterPublishDerivedCollectionBuildItem> generatedCollections, BuildProducer<RoqFrontMatterCollectionBuildItem> collectionsProducer, BuildProducer<RoqFrontMatterPageBuildItem> pagesProducer, RoqFrontMatterRecorder recorder) {
        ArrayList<Supplier<DocumentPage>> docs;
        if (rootUrlItem == null) {
            return;
        }
        Map<ConfiguredCollection, List<RoqFrontMatterPublishDocumentPageBuildItem>> byCollection = documents.stream().collect(Collectors.groupingBy(RoqFrontMatterPublishDocumentPageBuildItem::collection));
        HashMap<String, Supplier> documentsById = new HashMap<String, Supplier>();
        for (Map.Entry<ConfiguredCollection, List<RoqFrontMatterPublishDocumentPageBuildItem>> e : byCollection.entrySet()) {
            docs = new ArrayList<Supplier<DocumentPage>>();
            for (RoqFrontMatterPublishDocumentPageBuildItem item : e.getValue()) {
                RoqUrl url = item.url();
                Supplier document = recorder.createDocument(item.collection().id(), url, item.info(), item.data(), item.collection().hidden());
                documentsById.put(item.info().id(), document);
                pagesProducer.produce((BuildItem)new RoqFrontMatterPageBuildItem(item.info().id(), url, item.collection().hidden(), document));
                docs.add(document);
            }
            collectionsProducer.produce((BuildItem)new RoqFrontMatterCollectionBuildItem(e.getKey(), docs));
        }
        for (RoqFrontMatterPublishDerivedCollectionBuildItem i : generatedCollections) {
            docs = new ArrayList();
            for (String id : i.documentIds()) {
                Supplier doc = (Supplier)documentsById.get(id);
                if (doc == null) {
                    throw new IllegalStateException("No document found for id " + id);
                }
                docs.add(doc);
            }
            collectionsProducer.produce((BuildItem)new RoqFrontMatterCollectionBuildItem(i.collection(), docs));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void bindPages(RoqFrontMatterRootUrlBuildItem rootUrlItem, List<RoqFrontMatterPublishPageBuildItem> pages, BuildProducer<RoqFrontMatterNormalPageBuildItem> normalPagesProducer, BuildProducer<RoqFrontMatterPageBuildItem> pagesProducer, BuildProducer<RoqFrontMatterSiteIndexBuildItem> indexPageProducer, RoqFrontMatterRecorder recorder) {
        if (rootUrlItem == null) {
            return;
        }
        for (RoqFrontMatterPublishPageBuildItem page : pages) {
            Supplier recordedPage = recorder.createPage(page.url(), page.info(), page.data(), page.paginator());
            pagesProducer.produce((BuildItem)new RoqFrontMatterPageBuildItem(page.info().id(), page.url(), false, recordedPage));
            normalPagesProducer.produce((BuildItem)new RoqFrontMatterNormalPageBuildItem(page.info().id(), page.url(), recordedPage));
            if (!page.info().isSiteIndex()) continue;
            indexPageProducer.produce((BuildItem)new RoqFrontMatterSiteIndexBuildItem(recordedPage));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    RoqFrontMatterOutputBuildItem bindSite(LaunchModeBuildItem launchMode, RoqFrontMatterRootUrlBuildItem rootUrlItem, RoqFrontMatterSiteIndexBuildItem indexPageItem, List<RoqFrontMatterCollectionBuildItem> collectionItems, List<RoqFrontMatterPageBuildItem> pageItems, List<RoqFrontMatterNormalPageBuildItem> normalPageItems, BuildProducer<SyntheticBeanBuildItem> beansProducer, RoqFrontMatterRecorder recorder) {
        if (rootUrlItem == null) {
            return null;
        }
        if (indexPageItem == null) {
            throw new RoqSiteIndexNotFoundException("Site index page (index.html, index.md, etc.) not found. A site index is required by Roq. Please create one to continue.");
        }
        Map<ConfiguredCollection, List> collectionsMap = collectionItems.stream().collect(Collectors.toMap(RoqFrontMatterCollectionBuildItem::collection, RoqFrontMatterCollectionBuildItem::documents));
        Supplier collectionsSupplier = recorder.createRoqCollections(collectionsMap);
        List<Supplier> pages = normalPageItems.stream().map(RoqFrontMatterNormalPageBuildItem::page).toList();
        Supplier siteSupplier = recorder.createSite(rootUrlItem.rootUrl(), indexPageItem.page(), pages, collectionsSupplier);
        beansProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Site.class).named("site")).scope(Singleton.class)).unremovable()).supplier(siteSupplier).done());
        HashMap<String, RoqFrontMatterPageBuildItem> itemsMap = new HashMap<String, RoqFrontMatterPageBuildItem>();
        HashMap<String, Supplier<? extends Page>> allPagesByPath = new HashMap<String, Supplier<? extends Page>>();
        for (RoqFrontMatterPageBuildItem i : pageItems) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Published %spage '%s' on '%s'", (Object)(i.hidden() ? "hidden " : ""), (Object)i.id(), (Object)i.url().toString());
            }
            if (i.hidden()) continue;
            RoqFrontMatterPageBuildItem prev = itemsMap.put(i.url().resourcePath(), i);
            allPagesByPath.put(i.url().resourcePath(), i.page());
            if (prev == null) continue;
            if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
                LOGGER.warnf("Conflict detected: Duplicate path (%s) found in %s and %s. In development, the first occurrence will be kept, but this will cause an exception in normal mode.", (Object)i.url().resourcePath(), (Object)prev.id(), (Object)i.id());
                continue;
            }
            throw new RoqPathConflictException("Conflict detected: Duplicate path (%s) found in %s and %s".formatted(i.url().resourcePath(), prev.id(), i.id()));
        }
        return new RoqFrontMatterOutputBuildItem(allPagesByPath);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    public RouteBuildItem produceRoute(RoqSiteConfig config, RoqFrontMatterRecorder recorder, HttpRootPathBuildItem httpRootPath, RoqFrontMatterOutputBuildItem roqFrontMatterOutput) {
        if (roqFrontMatterOutput == null || roqFrontMatterOutput.allPagesByPath().isEmpty()) {
            return null;
        }
        return httpRootPath.routeBuilder().routeFunction(httpRootPath.relativePath(PathUtils.removeTrailingSlash((String)config.rootPath()) + "/*"), recorder.initializeRoute()).handlerType(HandlerType.BLOCKING).handler(recorder.handler(httpRootPath.getRootPath(), roqFrontMatterOutput.allPagesByPath())).build();
    }
}

