/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment.scan;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.quarkiverse.roq.deployment.items.RoqJacksonBuildItem;
import io.quarkiverse.roq.deployment.items.RoqProjectBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterDataModificationBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqFrontMatterReadingException;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqSiteScanningException;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqThemeConfigurationException;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterQuteMarkupBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterRawTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterStaticFileBuildItem;
import io.quarkiverse.roq.frontmatter.runtime.config.ConfiguredCollection;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.PageFiles;
import io.quarkiverse.roq.frontmatter.runtime.model.PageInfo;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.paths.PathVisit;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateRootBuildItem;
import io.quarkus.qute.runtime.QuteConfig;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RoqFrontMatterScanProcessor {
    private static final Logger LOGGER = Logger.getLogger(RoqFrontMatterScanProcessor.class);
    public static final Pattern FRONTMATTER_PATTERN = Pattern.compile("^---\\v.*?---\\v", 32);
    private static final String DRAFT_KEY = "draft";
    private static final String DATE_KEY = "date";
    private static final String LAYOUT_KEY = "layout";
    private static final String ESCAPE_KEY = "escape";
    private static final Pattern FILE_NAME_DATE_PATTERN = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
    private static final RoqFrontMatterQuteMarkupBuildItem.WrapperFilter ESCAPE_FILTER = new RoqFrontMatterQuteMarkupBuildItem.WrapperFilter("{|", "|}");
    public static final String ROQ_GENERATED_QUTE_PREFIX = "roq-gen/";
    public static final String LAYOUTS_DIR = "layouts";
    public static final String THEME_LAYOUTS_DIR_PREFIX = "theme-";
    public static final String TEMPLATES_DIR = "templates";
    public static final Pattern NON_PATH_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9_\\\\/.\\-]");
    private static final Set<String> HTML_OUTPUT_EXTENSIONS = Set.of("md", "markdown", "html", "htm", "xhtml", "asciidoc", "adoc");

    @BuildStep
    void registerEscapedTemplates(RoqSiteConfig config, BuildProducer<RoqFrontMatterDataModificationBuildItem> dataModificationProducer) {
        dataModificationProducer.produce((BuildItem)new RoqFrontMatterDataModificationBuildItem(sourceData -> {
            if (sourceData.type().isPage() && RoqFrontMatterScanProcessor.isPageEscaped(config).test(sourceData.relativePath())) {
                sourceData.fm().put(ESCAPE_KEY, (Object)true);
            }
            return sourceData.fm();
        }));
    }

    private static Predicate<String> isPageEscaped(RoqSiteConfig config) {
        return path -> config.escapedPages().orElse(List.of()).stream().anyMatch(s -> Path.of("", new String[0]).getFileSystem().getPathMatcher("glob:" + s).matches(Path.of(path, new String[0])));
    }

    @BuildStep
    void scan(RoqProjectBuildItem roqProject, List<RoqFrontMatterQuteMarkupBuildItem> markupList, RoqJacksonBuildItem jackson, QuteConfig quteConfig, BuildProducer<RoqFrontMatterRawTemplateBuildItem> dataProducer, BuildProducer<RoqFrontMatterStaticFileBuildItem> staticFilesProducer, BuildProducer<TemplatePathBuildItem> templatePathProducer, BuildProducer<TemplateRootBuildItem> templateRootProducer, List<RoqFrontMatterDataModificationBuildItem> dataModifications, RoqSiteConfig siteConfig, BuildProducer<HotDeploymentWatchedFileBuildItem> watch) {
        try {
            dataModifications.sort(Comparator.comparing(RoqFrontMatterDataModificationBuildItem::order));
            List<RoqFrontMatterRawTemplateBuildItem> items = this.resolveItems(roqProject, jackson.getYamlMapper(), quteConfig, siteConfig, RoqFrontMatterQuteMarkupBuildItem.toWrapperFilters(markupList), watch, dataModifications, templatePathProducer, templateRootProducer, staticFilesProducer);
            Set ids = items.stream().map(RoqFrontMatterRawTemplateBuildItem::id).collect(Collectors.toSet());
            for (RoqFrontMatterRawTemplateBuildItem item : items) {
                String layoutId;
                if (item.type().isThemeLayout() && !ids.contains(layoutId = RoqFrontMatterScanProcessor.removeThemePrefix(item.id()))) {
                    RoqFrontMatterScanProcessor.produceRawTemplate(dataProducer, new RoqFrontMatterRawTemplateBuildItem(item.info().changeIds(RoqFrontMatterScanProcessor::removeThemePrefix), item.layout(), RoqFrontMatterRawTemplateBuildItem.TemplateType.LAYOUT, item.data(), item.collection(), item.generatedTemplate(), item.published(), item.attachments()));
                }
                RoqFrontMatterScanProcessor.produceRawTemplate(dataProducer, item);
            }
        }
        catch (IOException e) {
            throw new RoqSiteScanningException("Unable to scan the Roq project", e);
        }
    }

    private static void produceRawTemplate(BuildProducer<RoqFrontMatterRawTemplateBuildItem> dataProducer, RoqFrontMatterRawTemplateBuildItem item) {
        LOGGER.debugf("Roq is producing a raw template '%s'", (Object)item.info().generatedTemplateId());
        dataProducer.produce((BuildItem)item);
    }

    private static String removeThemePrefix(String id) {
        return id.replace(RoqFrontMatterScanProcessor.getLayoutsDir(RoqFrontMatterRawTemplateBuildItem.TemplateType.THEME_LAYOUT), RoqFrontMatterScanProcessor.getLayoutsDir(RoqFrontMatterRawTemplateBuildItem.TemplateType.LAYOUT));
    }

    public List<RoqFrontMatterRawTemplateBuildItem> resolveItems(RoqProjectBuildItem roqProject, YAMLMapper mapper, QuteConfig quteConfig, RoqSiteConfig config, Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, List<RoqFrontMatterDataModificationBuildItem> dataModifications, BuildProducer<TemplatePathBuildItem> templatePathProducer, BuildProducer<TemplateRootBuildItem> templateRootProducer, BuildProducer<RoqFrontMatterStaticFileBuildItem> staticFilesProducer) throws IOException {
        ArrayList<RoqFrontMatterRawTemplateBuildItem> items = new ArrayList<RoqFrontMatterRawTemplateBuildItem>();
        roqProject.consumeRoqDir(RoqFrontMatterScanProcessor.createRoqDirConsumer(mapper, quteConfig, config, markups, watch, dataModifications, staticFilesProducer, templatePathProducer, items));
        RoqProjectBuildItem.visitRuntimeResources((String)TEMPLATES_DIR, t -> {
            RoqFrontMatterScanProcessor.scanLayouts(mapper, quteConfig, config, markups, watch, dataModifications, items, t.getPath().getParent(), t.getPath(), RoqFrontMatterRawTemplateBuildItem.TemplateType.LAYOUT);
            RoqFrontMatterScanProcessor.scanLayouts(mapper, quteConfig, config, markups, watch, dataModifications, items, t.getPath().getParent(), t.getPath(), RoqFrontMatterRawTemplateBuildItem.TemplateType.THEME_LAYOUT);
        });
        roqProject.consumePathFromRoqResourceDir(config.contentDir(), l -> {
            RoqFrontMatterScanProcessor.watchResourceDir(watch, l);
            RoqFrontMatterScanProcessor.scanContent(mapper, quteConfig, config, markups, watch, dataModifications, items, l.getPath().getParent(), l.getPath());
        });
        if (!roqProject.isRoqResourcesInRoot()) {
            templateRootProducer.produce((BuildItem)new TemplateRootBuildItem(PathUtils.join((String)roqProject.roqResourceDir(), (String)TEMPLATES_DIR)));
            roqProject.consumePathFromRoqResourceDir(TEMPLATES_DIR, l -> RoqFrontMatterScanProcessor.scanLayouts(mapper, quteConfig, config, markups, watch, dataModifications, items, l.getPath().getParent(), l.getPath(), RoqFrontMatterRawTemplateBuildItem.TemplateType.LAYOUT));
        }
        return items;
    }

    private static Consumer<Path> createRoqDirConsumer(YAMLMapper mapper, QuteConfig quteConfig, RoqSiteConfig config, Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, List<RoqFrontMatterDataModificationBuildItem> dataModifications, BuildProducer<RoqFrontMatterStaticFileBuildItem> staticFilesProducer, BuildProducer<TemplatePathBuildItem> templatePathProducer, List<RoqFrontMatterRawTemplateBuildItem> items) {
        return siteDir -> {
            if (!Files.isDirectory(siteDir, new LinkOption[0])) {
                return;
            }
            Path templatesDir = siteDir.resolve(TEMPLATES_DIR);
            RoqFrontMatterScanProcessor.watchDirectory(templatesDir, watch);
            RoqFrontMatterScanProcessor.scanTemplates(quteConfig, config, watch, templatePathProducer, templatesDir);
            RoqFrontMatterScanProcessor.scanLayouts(mapper, quteConfig, config, markups, watch, dataModifications, items, siteDir, templatesDir, RoqFrontMatterRawTemplateBuildItem.TemplateType.LAYOUT);
            Path contentDir = siteDir.resolve(config.contentDir());
            RoqFrontMatterScanProcessor.watchDirectory(contentDir, watch);
            RoqFrontMatterScanProcessor.scanContent(mapper, quteConfig, config, markups, watch, dataModifications, items, siteDir, contentDir);
        };
    }

    private static void scanContent(YAMLMapper mapper, QuteConfig quteConfig, RoqSiteConfig config, Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, List<RoqFrontMatterDataModificationBuildItem> dataModifications, List<RoqFrontMatterRawTemplateBuildItem> items, Path siteDir, Path contentDir) {
        if (!Files.isDirectory(contentDir, new LinkOption[0])) {
            return;
        }
        Map collections = config.collections().stream().collect(Collectors.toMap(ConfiguredCollection::id, Function.identity()));
        try (Stream<Path> stream = Files.walk(contentDir, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Predicate.not(RoqFrontMatterScanProcessor.isFileExcluded(contentDir.getParent(), config))).filter(RoqFrontMatterScanProcessor.isTemplate(quteConfig)).forEach(p -> {
                String dirName = contentDir.relativize((Path)p).getName(0).toString();
                if (collections.containsKey(dirName)) {
                    RoqFrontMatterScanProcessor.addBuildItem(siteDir, contentDir, items, mapper, quteConfig, config, watch, markups, dataModifications, (ConfiguredCollection)collections.get(dirName), RoqFrontMatterRawTemplateBuildItem.TemplateType.DOCUMENT_PAGE).accept((Path)p);
                } else {
                    RoqFrontMatterScanProcessor.addBuildItem(siteDir, contentDir, items, mapper, quteConfig, config, watch, markups, dataModifications, null, RoqFrontMatterRawTemplateBuildItem.TemplateType.NORMAL_PAGE).accept((Path)p);
                }
            });
        }
        catch (IOException e) {
            throw new RoqSiteScanningException("Unable to scan content files at location: %s".formatted(contentDir), e);
        }
    }

    private static void watchDirectory(Path dir, BuildProducer<HotDeploymentWatchedFileBuildItem> watch) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            stream.forEach(f -> {
                watch.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setLocation(f.toAbsolutePath().toString()).build());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Watching %s for changes", f);
                }
            });
        }
        catch (IOException e) {
            throw new RoqSiteScanningException("Unable to read directory: %s".formatted(dir), e);
        }
    }

    private static void watchResourceDir(BuildProducer<HotDeploymentWatchedFileBuildItem> watch, PathVisit l) {
        String dir = l.getRelativePath();
        watch.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setLocationPredicate(p -> p.startsWith(dir)).build());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Watching resources %s for changes", (Object)dir);
        }
    }

    private static void scanLayouts(YAMLMapper mapper, QuteConfig quteConfig, RoqSiteConfig config, Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, List<RoqFrontMatterDataModificationBuildItem> dataModifications, List<RoqFrontMatterRawTemplateBuildItem> items, Path siteDir, Path templatesRoot, RoqFrontMatterRawTemplateBuildItem.TemplateType type) {
        String dir = RoqFrontMatterScanProcessor.getLayoutsDir(type);
        Path layoutsDir = templatesRoot.resolve(dir);
        if (!Files.isDirectory(layoutsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(layoutsDir, new FileVisitOption[0]);){
            Consumer<Path> layoutsConsumer = RoqFrontMatterScanProcessor.addBuildItem(siteDir, templatesRoot, items, mapper, quteConfig, config, watch, markups, dataModifications, null, type);
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Predicate.not(RoqFrontMatterScanProcessor.isFileExcluded(templatesRoot.getParent(), config))).filter(RoqFrontMatterScanProcessor.isTemplate(quteConfig)).filter(RoqFrontMatterScanProcessor::isPageTargetHtml).forEach(layoutsConsumer);
        }
        catch (IOException e) {
            throw new RoqSiteScanningException("Error while scanning layouts directory: %s".formatted(templatesRoot), e);
        }
    }

    private static String getLayoutsDir(RoqFrontMatterRawTemplateBuildItem.TemplateType type) {
        if (type.isThemeLayout()) {
            return "theme-layouts";
        }
        return LAYOUTS_DIR;
    }

    private static void scanTemplates(QuteConfig quteConfig, RoqSiteConfig config, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, BuildProducer<TemplatePathBuildItem> templatePathProducer, Path templatesRoot) {
        if (!Files.isDirectory(templatesRoot, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(templatesRoot, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(RoqFrontMatterScanProcessor.isTemplate(quteConfig)).filter(Predicate.not(RoqFrontMatterScanProcessor.isFileExcluded(templatesRoot.getParent(), config))).forEach(p -> {
                String dirName = templatesRoot.relativize((Path)p).getName(0).toString();
                if (LAYOUTS_DIR.equals(dirName)) {
                    return;
                }
                try {
                    String link = PathUtils.toUnixPath((String)templatesRoot.relativize((Path)p).toString());
                    String content = Files.readString(p, StandardCharsets.UTF_8);
                    if (content.length() > 65535) {
                        LOGGER.warnf("Template '%s' is too large for recording and will be ignored. Consider splitting it into smaller parts.", (Object)link);
                        return;
                    }
                    templatePathProducer.produce((BuildItem)TemplatePathBuildItem.builder().priority(30).path(link).content(content).extensionInfo("roq-frontmatter").build());
                }
                catch (IOException e) {
                    throw new RoqSiteScanningException("Error while reading template file: %s".formatted(p), e);
                }
            });
        }
        catch (IOException e) {
            throw new RoqSiteScanningException("Error while reading templates dir: %s".formatted(templatesRoot), e);
        }
    }

    public static Predicate<Path> isTemplate(QuteConfig config) {
        HashSet<String> suffixes = new HashSet<String>(config.suffixes());
        suffixes.addAll(HTML_OUTPUT_EXTENSIONS);
        return path -> suffixes.contains(PathUtils.getExtension((String)path.toString()));
    }

    private static Consumer<Path> addBuildItem(Path siteDir, Path contentDir, List<RoqFrontMatterRawTemplateBuildItem> items, YAMLMapper mapper, QuteConfig quteConfig, RoqSiteConfig config, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, List<RoqFrontMatterDataModificationBuildItem> dataModifications, ConfiguredCollection collection, RoqFrontMatterRawTemplateBuildItem.TemplateType type) {
        return file -> {
            JsonObject fm;
            String fullContent;
            String sourcePath = PathUtils.toUnixPath((String)contentDir.relativize((Path)file).toString());
            String normalizedPath = RoqFrontMatterScanProcessor.normalizePath(sourcePath);
            String quteTemplatePath = ROQ_GENERATED_QUTE_PREFIX + PathUtils.removeExtension((String)normalizedPath) + RoqFrontMatterScanProcessor.resolveOutputExtension(markups, normalizedPath);
            boolean published = type.isPage();
            String id = type.isPage() ? sourcePath : PathUtils.removeExtension((String)sourcePath);
            boolean isHtml = RoqFrontMatterScanProcessor.isPageTargetHtml(file);
            boolean isIndex = isHtml && "index".equals(PathUtils.removeExtension((String)PathUtils.fileName((String)sourcePath)));
            boolean isSiteIndex = isHtml && id.startsWith("index.");
            try {
                fullContent = Files.readString(file, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RoqSiteScanningException("Error while reading template file: %s".formatted(sourcePath), e);
            }
            String content = fullContent;
            if (RoqFrontMatterScanProcessor.hasFrontMatter(fullContent)) {
                try {
                    fm = RoqFrontMatterScanProcessor.readFM(mapper, fullContent);
                }
                catch (JsonProcessingException | IllegalArgumentException e) {
                    throw new RoqFrontMatterReadingException("Error reading YAML FrontMatter block (enclosed by '---') in file: %s".formatted(sourcePath));
                }
                content = RoqFrontMatterScanProcessor.stripFrontMatter(fullContent);
            } else {
                fm = new JsonObject();
            }
            ZonedDateTime date = RoqFrontMatterScanProcessor.parsePublishDate(file, fm, config.dateFormat(), config.timeZone());
            boolean noFuture = !config.future() && (collection == null || !collection.future());
            ZonedDateTime now = ZonedDateTime.now();
            if (date != null && noFuture && date.isAfter(now)) {
                LOGGER.warnf("Ignoring page '%s' because it's scheduled for later (%s > %s). To display future articles, use -Dsite.future=true%s.", new Object[]{sourcePath, date, now, collection == null ? "" : " or -Dsite.collections.%s.future=true".formatted(collection.id())});
                return;
            }
            String dateString = date.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
            String defaultLayout = type.isPage() && isHtml ? (collection != null ? collection.layout() : (String)config.pageLayout().orElse(null)) : null;
            String layoutId = RoqFrontMatterScanProcessor.normalizedLayout(config.theme(), fm.getString(LAYOUT_KEY), defaultLayout);
            for (RoqFrontMatterDataModificationBuildItem modification : dataModifications) {
                fm = modification.modifier().modify(new RoqFrontMatterDataModificationBuildItem.SourceData((Path)file, sourcePath, collection, type, fm));
            }
            boolean draft = fm.getBoolean(DRAFT_KEY, Boolean.valueOf(false));
            if (!config.draft() && draft) {
                return;
            }
            RoqFrontMatterQuteMarkupBuildItem.WrapperFilter markupFilter = RoqFrontMatterScanProcessor.getMarkupFilter(markups, sourcePath);
            boolean escaped = fm.getBoolean(ESCAPE_KEY, Boolean.valueOf(false));
            RoqFrontMatterQuteMarkupBuildItem.WrapperFilter escapeFilter = RoqFrontMatterScanProcessor.getEscapeFilter(escaped);
            RoqFrontMatterQuteMarkupBuildItem.WrapperFilter includeFilter = RoqFrontMatterScanProcessor.getIncludeFilter(layoutId);
            String contentWithMarkup = markupFilter.apply(escapeFilter.apply(content));
            String generatedTemplate = includeFilter.apply(contentWithMarkup);
            ArrayList<RoqFrontMatterRawTemplateBuildItem.Attachment> attachments = null;
            if (isIndex) {
                attachments = new ArrayList<RoqFrontMatterRawTemplateBuildItem.Attachment>();
                if (isSiteIndex) {
                    RoqFrontMatterScanProcessor.scanAttachments(siteDir, config, quteConfig, watch, attachments, siteDir, siteDir.resolve(config.staticDir()), false);
                    RoqFrontMatterScanProcessor.scanAttachments(siteDir, config, quteConfig, watch, attachments, siteDir.resolve(config.publicDir()), siteDir.resolve(config.publicDir()), false);
                } else {
                    RoqFrontMatterScanProcessor.scanAttachments(siteDir, config, quteConfig, watch, attachments, file.getParent(), file.getParent(), true);
                }
            }
            PageInfo info = PageInfo.create((String)id, (boolean)draft, (String)dateString, (String)contentWithMarkup, (String)sourcePath, (String)quteTemplatePath, (PageFiles)(attachments != null ? new PageFiles(attachments.stream().map(RoqFrontMatterRawTemplateBuildItem.Attachment::name).toList(), config.slugifyFiles()) : null), (boolean)isHtml, (boolean)isSiteIndex);
            items.add(new RoqFrontMatterRawTemplateBuildItem(info, layoutId, type, fm, collection, generatedTemplate, published, attachments));
        };
    }

    private static void scanAttachments(Path siteDir, RoqSiteConfig config, QuteConfig quteConfig, BuildProducer<HotDeploymentWatchedFileBuildItem> watch, List<RoqFrontMatterRawTemplateBuildItem.Attachment> attachments, Path refDir, Path attachmentDir, boolean ignoreTemplates) {
        if (Files.isDirectory(attachmentDir, new LinkOption[0])) {
            RoqFrontMatterScanProcessor.watchDirectory(attachmentDir, watch);
            try (Stream<Path> stream = Files.walk(attachmentDir, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Predicate.not(RoqFrontMatterScanProcessor.isFileExcluded(siteDir, config))).filter(p -> !ignoreTemplates || !RoqFrontMatterScanProcessor.isTemplate(quteConfig).test((Path)p)).forEach(p -> attachments.add(new RoqFrontMatterRawTemplateBuildItem.Attachment(RoqFrontMatterScanProcessor.resolveAttachmentLink(config, p, refDir), (Path)p)));
            }
            catch (IOException e) {
                throw new RoqSiteScanningException("Error scanning static attachment files in directory: %s".formatted(attachmentDir), e);
            }
        }
    }

    private static String resolveAttachmentLink(RoqSiteConfig config, Path p, Path pageDir) {
        String relative = PathUtils.toUnixPath((String)pageDir.relativize(p).toString());
        if (config.slugifyFiles()) {
            return PageFiles.slugifyFile((String)relative);
        }
        return relative;
    }

    private static JsonObject readFM(YAMLMapper mapper, String fullContent) throws JsonProcessingException, IllegalArgumentException {
        String frontMatter = RoqFrontMatterScanProcessor.getFrontMatter(fullContent);
        if (frontMatter.isBlank()) {
            return new JsonObject();
        }
        JsonNode rootNode = mapper.readTree(frontMatter);
        Map map = (Map)mapper.convertValue((Object)rootNode, Map.class);
        return new JsonObject(map);
    }

    private static String normalizePath(String sourcePath) {
        return NON_PATH_CHAR_PATTERN.matcher(sourcePath).replaceAll("-");
    }

    protected static ZonedDateTime parsePublishDate(Path file, JsonObject frontMatter, String dateFormat, Optional<String> timeZone) {
        boolean fromFileName;
        String dateString;
        if (frontMatter.containsKey(DATE_KEY)) {
            dateString = frontMatter.getString(DATE_KEY);
            fromFileName = false;
        } else {
            Matcher matcher = FILE_NAME_DATE_PATTERN.matcher(file.toString());
            if (!matcher.find()) {
                return ZonedDateTime.now();
            }
            dateString = matcher.group(1);
            fromFileName = true;
        }
        try {
            return new DateTimeFormatterBuilder().appendPattern(dateFormat).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter().withZone(timeZone.isPresent() ? ZoneId.of(timeZone.get()) : ZoneId.systemDefault()).parse((CharSequence)dateString, ZonedDateTime::from);
        }
        catch (DateTimeParseException e) {
            if (fromFileName) {
                throw new RoqSiteScanningException("Error while reading date '%s' in file name: '%s'\nreason: %s".formatted(dateString, file, e.getLocalizedMessage()));
            }
            throw new RoqFrontMatterReadingException("Error while reading FrontMatter 'date' ('%s') in file: '%s'\nreason: %s".formatted(dateString, file, e.getLocalizedMessage()));
        }
    }

    private static RoqFrontMatterQuteMarkupBuildItem.WrapperFilter getEscapeFilter(boolean escaped) {
        if (!escaped) {
            return RoqFrontMatterQuteMarkupBuildItem.WrapperFilter.EMPTY;
        }
        return ESCAPE_FILTER;
    }

    private static RoqFrontMatterQuteMarkupBuildItem.WrapperFilter getIncludeFilter(String layout) {
        if (layout == null) {
            return RoqFrontMatterQuteMarkupBuildItem.WrapperFilter.EMPTY;
        }
        String prefix = "{#include %s%s}\n".formatted(ROQ_GENERATED_QUTE_PREFIX, layout);
        return new RoqFrontMatterQuteMarkupBuildItem.WrapperFilter(prefix, "\n{/include}");
    }

    private static RoqFrontMatterQuteMarkupBuildItem.WrapperFilter getMarkupFilter(Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, String fileName) {
        return RoqFrontMatterQuteMarkupBuildItem.QuteMarkupSection.find(markups, fileName, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter.EMPTY);
    }

    private static String normalizedLayout(Optional<String> theme, String layout, String defaultLayout) {
        String normalized = layout;
        if (normalized == null) {
            normalized = defaultLayout;
            if (normalized == null || normalized.isBlank() || "none".equalsIgnoreCase(normalized)) {
                return null;
            }
            normalized = defaultLayout;
            if (normalized.contains(":theme/") && theme.isEmpty()) {
                normalized = normalized.replace(":theme/", "");
            }
        }
        if (normalized.contains(":theme")) {
            if (theme.isPresent()) {
                normalized = normalized.replace(":theme", theme.get());
            } else {
                throw new RoqThemeConfigurationException("No theme detected! Using ':theme' in 'layout: %s' is only possible with a theme installed as a dependency.".formatted(layout));
            }
        }
        if (!normalized.contains(PathUtils.addTrailingSlash((String)LAYOUTS_DIR))) {
            normalized = PathUtils.join((String)LAYOUTS_DIR, (String)normalized);
        }
        return PathUtils.removeExtension((String)normalized);
    }

    public static String getLayoutKey(Optional<String> theme, String resolvedLayout) {
        String result = resolvedLayout;
        if (result.startsWith(PathUtils.addTrailingSlash((String)LAYOUTS_DIR))) {
            result = result.substring(PathUtils.addTrailingSlash((String)LAYOUTS_DIR).length());
            if (theme.isPresent() && result.contains(theme.get())) {
                result = result.replace(theme.get(), ":theme");
            }
        }
        return result;
    }

    private static String resolveOutputExtension(Map<String, RoqFrontMatterQuteMarkupBuildItem.WrapperFilter> markups, String fileName) {
        if (RoqFrontMatterQuteMarkupBuildItem.QuteMarkupSection.find(markups, fileName, null) != null) {
            return ".html";
        }
        String extension = PathUtils.getExtension((String)fileName);
        if (extension == null) {
            return "";
        }
        String mimeTypeForExtension = MimeMapping.getMimeTypeForExtension((String)extension);
        if (mimeTypeForExtension != null) {
            return "." + extension;
        }
        return ".html";
    }

    private static Predicate<Path> isFileExcluded(Path siteDir, RoqSiteConfig config) {
        return path -> config.ignoredFiles().stream().anyMatch(s -> path.getFileSystem().getPathMatcher("glob:" + s).matches(siteDir.relativize((Path)path)));
    }

    private static boolean isPageTargetHtml(Path path) {
        String extension = PathUtils.getExtension((String)path.toString());
        return HTML_OUTPUT_EXTENSIONS.contains(extension);
    }

    private static String getFrontMatter(String content) {
        int endOfFrontMatter = content.indexOf("---", 3);
        if (endOfFrontMatter != -1) {
            return content.substring(3, endOfFrontMatter).trim();
        }
        return "";
    }

    private static String stripFrontMatter(String content) {
        return FRONTMATTER_PATTERN.matcher(content).replaceFirst("");
    }

    private static boolean hasFrontMatter(String content) {
        return FRONTMATTER_PATTERN.matcher(content).find();
    }
}

