/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment.scan;

import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.builder.item.MultiBuildItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class RoqFrontMatterQuteMarkupBuildItem
extends MultiBuildItem {
    private final Set<String> extensions;
    private final QuteMarkupSection markupSection;

    public RoqFrontMatterQuteMarkupBuildItem(Set<String> extensions, QuteMarkupSection markupSection) {
        this.extensions = extensions;
        this.markupSection = markupSection;
    }

    public Set<String> extensions() {
        return this.extensions;
    }

    public QuteMarkupSection markupSection() {
        return this.markupSection;
    }

    public static Map<String, WrapperFilter> toWrapperFilters(List<RoqFrontMatterQuteMarkupBuildItem> list) {
        HashMap<String, WrapperFilter> markups = new HashMap<String, WrapperFilter>();
        for (RoqFrontMatterQuteMarkupBuildItem item : list) {
            for (String extension : item.extensions()) {
                markups.put(extension, new WrapperFilter(item.markupSection.open + "\n", "\n" + item.markupSection.close));
            }
        }
        return markups;
    }

    public record QuteMarkupSection(String open, String close) {
        public static WrapperFilter find(Map<String, WrapperFilter> markups, String fileName, WrapperFilter defaultFilter) {
            String extension = PathUtils.getExtension((String)fileName);
            if (extension == null) {
                return defaultFilter;
            }
            if (!markups.containsKey(extension)) {
                return defaultFilter;
            }
            return markups.get(extension);
        }
    }

    public record WrapperFilter(String prefix, String suffix) implements Function<String, String>
    {
        public static final WrapperFilter EMPTY = new WrapperFilter("", "");

        @Override
        public String apply(String s) {
            if (EMPTY.equals(this)) {
                return s;
            }
            return this.prefix() + s + this.suffix();
        }
    }
}

