/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment;

import io.quarkiverse.roq.frontmatter.deployment.RoqFrontMatterOutputBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqPathConflictException;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterRawTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterStaticFileBuildItem;
import io.quarkiverse.roq.frontmatter.runtime.RoqFrontMatterMessages;
import io.quarkiverse.roq.frontmatter.runtime.RoqQuteEngineObserver;
import io.quarkiverse.roq.frontmatter.runtime.RoqTemplateExtension;
import io.quarkiverse.roq.frontmatter.runtime.RoqTemplateGlobal;
import io.quarkiverse.roq.frontmatter.runtime.RoqTemplates;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.NormalPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.Paginator;
import io.quarkiverse.roq.frontmatter.runtime.model.RootUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollections;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkiverse.roq.generator.deployment.items.SelectedPathBuildItem;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.ValidationParserHookBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.spi.GeneratedStaticResourceBuildItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;

public class RoqFrontMatterProcessor {
    private static final Logger LOGGER = Logger.getLogger(RoqFrontMatterProcessor.class);
    public static final String FEATURE = "roq-frontmatter";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void bindQuteTemplates(BuildProducer<TemplatePathBuildItem> templatePathProducer, BuildProducer<ValidationParserHookBuildItem> validationParserHookProducer, List<RoqFrontMatterRawTemplateBuildItem> roqFrontMatterTemplates, RoqFrontMatterOutputBuildItem roqOutput) {
        if (roqOutput == null) {
            return;
        }
        HashSet<String> docTemplates = new HashSet<String>();
        HashSet<String> pageTemplates = new HashSet<String>();
        HashSet<String> layoutTemplates = new HashSet<String>();
        for (RoqFrontMatterRawTemplateBuildItem item : roqFrontMatterTemplates) {
            templatePathProducer.produce((BuildItem)TemplatePathBuildItem.builder().path(item.info().generatedTemplateId()).extensionInfo(FEATURE).content(item.generatedTemplate()).build());
            if (item.published()) {
                String contentTemplateId = RoqTemplates.resolveGeneratedContentTemplateId((String)item.info().generatedTemplateId());
                templatePathProducer.produce((BuildItem)TemplatePathBuildItem.builder().path(contentTemplateId).extensionInfo(FEATURE).content(item.generatedContentTemplate()).build());
                if (item.collection() != null) {
                    docTemplates.add(contentTemplateId);
                    docTemplates.add(item.info().generatedTemplateId());
                    continue;
                }
                pageTemplates.add(contentTemplateId);
                pageTemplates.add(item.info().generatedTemplateId());
                continue;
            }
            layoutTemplates.add(item.info().generatedTemplateId());
        }
        validationParserHookProducer.produce((BuildItem)new ValidationParserHookBuildItem(c -> {
            if (RoqTemplates.isLayoutSourceTemplate((String)c.getTemplateId())) {
                c.addContentFilter(s -> "");
                return;
            }
            if (docTemplates.contains(c.getTemplateId())) {
                c.addParameter("page", DocumentPage.class.getName());
                c.addParameter("site", Site.class.getName());
            } else if (pageTemplates.contains(c.getTemplateId())) {
                c.addParameter("page", NormalPage.class.getName());
                c.addParameter("site", Site.class.getName());
            } else if (layoutTemplates.contains(c.getTemplateId())) {
                c.addParameter("page", Page.class.getName());
                c.addParameter("site", Site.class.getName());
            }
        }));
    }

    @BuildStep
    void registerAdditionalBeans(RoqFrontMatterOutputBuildItem roqOutput, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (roqOutput == null) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{RoqQuteEngineObserver.class, RoqFrontMatterMessages.class, RoqTemplateExtension.class, RoqTemplateGlobal.class, Page.class, RoqUrl.class, RootUrl.class, DocumentPage.class, NormalPage.class, RoqCollections.class, RoqCollection.class, Paginator.class}).setUnremovable().build());
    }

    @BuildStep
    void bindEndpoints(RoqSiteConfig config, BuildProducer<SelectedPathBuildItem> selectedPathProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer, RoqFrontMatterOutputBuildItem roqOutput) {
        if (roqOutput == null) {
            return;
        }
        if (config.generator()) {
            for (String path : roqOutput.allPagesByPath().keySet()) {
                String selectedPath = PathUtils.getExtension((String)path) != null ? path : PathUtils.addTrailingSlash((String)path);
                selectedPathProducer.produce((BuildItem)new SelectedPathBuildItem(selectedPath, null));
                notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(PathUtils.prefixWithSlash((String)path)));
            }
        }
    }

    @BuildStep
    void bindStaticFiles(RoqSiteConfig config, LaunchModeBuildItem launchMode, BuildProducer<SelectedPathBuildItem> selectedPathProducer, List<RoqFrontMatterStaticFileBuildItem> staticFiles, BuildProducer<GeneratedStaticResourceBuildItem> staticResourcesProducer) {
        HashMap<String, String> paths = new HashMap<String, String>();
        for (RoqFrontMatterStaticFileBuildItem staticFile : staticFiles) {
            String endpoint = PathUtils.prefixWithSlash((String)staticFile.link());
            String prev = paths.put(endpoint, staticFile.filePath().toString());
            if (prev != null) {
                if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
                    LOGGER.warnf("Conflict detected: Duplicate path (%s) found in %s and %s. In development, the first occurrence will be kept, but this will cause an exception in normal mode.", (Object)endpoint, (Object)prev, (Object)staticFile.filePath());
                    continue;
                }
                throw new RoqPathConflictException("Conflict detected: Duplicate path (%s) found in %s and %s".formatted(endpoint, prev, staticFile.filePath()));
            }
            LOGGER.debugf("Published static file: '%s'", (Object)endpoint);
            selectedPathProducer.produce((BuildItem)new SelectedPathBuildItem(endpoint, null));
            staticResourcesProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem(endpoint, staticFile.filePath()));
        }
    }
}

