/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.deployment.publish;

import io.quarkiverse.roq.frontmatter.deployment.Paginate;
import io.quarkiverse.roq.frontmatter.deployment.RoqFrontMatterRootUrlBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.TemplateLink;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterDocumentTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterPaginateTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishDerivedCollectionBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishDocumentPageBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.publish.RoqFrontMatterPublishPageBuildItem;
import io.quarkiverse.roq.frontmatter.runtime.config.ConfiguredCollection;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.PageInfo;
import io.quarkiverse.roq.frontmatter.runtime.model.Paginator;
import io.quarkiverse.roq.frontmatter.runtime.model.RootUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

class RoqFrontMatterPublishProcessor {
    private static final Logger LOGGER = Logger.getLogger(RoqFrontMatterPublishProcessor.class);

    RoqFrontMatterPublishProcessor() {
    }

    @BuildStep
    public void publishCollections(List<RoqFrontMatterDocumentTemplateBuildItem> documentTemplates, BuildProducer<RoqFrontMatterPublishDocumentPageBuildItem> publishDocuments) {
        for (RoqFrontMatterDocumentTemplateBuildItem documentTemplate : documentTemplates) {
            publishDocuments.produce((BuildItem)new RoqFrontMatterPublishDocumentPageBuildItem(documentTemplate.url(), documentTemplate.raw().info(), documentTemplate.collection(), documentTemplate.data()));
        }
    }

    @BuildStep
    public void paginatePublish(RoqSiteConfig config, RoqFrontMatterRootUrlBuildItem rootUrlItem, BuildProducer<RoqFrontMatterPublishPageBuildItem> pagesProducer, List<RoqFrontMatterPaginateTemplateBuildItem> paginationList, List<RoqFrontMatterPublishDocumentPageBuildItem> documents, List<RoqFrontMatterPublishDerivedCollectionBuildItem> derivedCollections) {
        if (paginationList.isEmpty() || rootUrlItem == null) {
            return;
        }
        RootUrl rootUrl = rootUrlItem.rootUrl();
        HashMap<String, AtomicInteger> sizeByCollection = new HashMap<String, AtomicInteger>();
        for (RoqFrontMatterPublishDocumentPageBuildItem document : documents) {
            sizeByCollection.computeIfAbsent(document.collection().id(), k -> new AtomicInteger()).incrementAndGet();
        }
        for (RoqFrontMatterPublishDerivedCollectionBuildItem derivedCollection : derivedCollections) {
            sizeByCollection.computeIfAbsent(derivedCollection.collection().id(), k -> new AtomicInteger()).addAndGet(derivedCollection.documentIds().size());
        }
        for (RoqFrontMatterPaginateTemplateBuildItem pagination : paginationList) {
            int i;
            JsonObject data = pagination.data();
            Paginate paginate = RoqFrontMatterPublishProcessor.readPaginate(pagination.info().sourcePath(), data, pagination.defaultPaginatedCollection());
            AtomicInteger collectionSize = (AtomicInteger)sizeByCollection.get(paginate.collection());
            if (collectionSize == null) {
                throw new ConfigurationException("Paginate collection not found '" + paginate.collection() + "' in " + pagination.info().sourcePath());
            }
            int total = collectionSize.get();
            if (paginate.size() <= 0) {
                throw new ConfigurationException("Page size must be greater than zero.");
            }
            int countPages = (total + paginate.size() - 1) / paginate.size();
            ArrayList<PageToPublish> paginatedPages = new ArrayList<PageToPublish>();
            String linkTemplate = paginate.link() != null ? paginate.link() : "/:collection/page:page/";
            for (i = 1; i <= countPages; ++i) {
                RoqUrl paginatedUrl;
                if (i == 1) {
                    paginatedUrl = pagination.url();
                } else {
                    String link = TemplateLink.paginateLink(config.pathPrefixOrEmpty(), linkTemplate, new TemplateLink.PaginateLinkData(pagination.info(), paginate.collection(), Integer.toString(i), data));
                    paginatedUrl = rootUrl.resolve(link);
                }
                PageInfo info = pagination.info();
                if (i > 1) {
                    info = info.changeId(PathUtils.removeExtension((String)info.sourcePath()) + "_p" + i + "." + info.sourceFileExtension());
                }
                paginatedPages.add(new PageToPublish(paginatedUrl, info, data));
            }
            for (i = 1; i <= countPages; ++i) {
                Integer prev = i > 1 ? Integer.valueOf(i - 1) : null;
                Integer next = i <= countPages - 1 ? Integer.valueOf(i + 1) : null;
                PageToPublish currentPage = (PageToPublish)paginatedPages.get(i - 1);
                RoqUrl previousUrl = null;
                RoqUrl nextUrl = null;
                if (prev != null) {
                    PageToPublish previousPage = (PageToPublish)paginatedPages.get(prev - 1);
                    previousUrl = previousPage.url();
                }
                if (next != null) {
                    PageToPublish nextPage = (PageToPublish)paginatedPages.get(next - 1);
                    nextUrl = nextPage.url();
                }
                RoqUrl firstUrl = ((PageToPublish)paginatedPages.get(0)).url();
                Paginator paginator = new Paginator(paginate.collection(), total, paginate.size(), countPages, i, firstUrl, prev, previousUrl, next, nextUrl);
                pagesProducer.produce((BuildItem)new RoqFrontMatterPublishPageBuildItem(currentPage.url(), currentPage.info(), currentPage.data(), paginator));
            }
        }
    }

    private static Paginate readPaginate(String name, JsonObject data, ConfiguredCollection defaultCollection) {
        Boolean paginate;
        Object value = data.getValue("paginate");
        if (value instanceof JsonObject) {
            JsonObject paginate2 = (JsonObject)value;
            String collection = paginate2.getString("collection", defaultCollection == null ? null : defaultCollection.id());
            if (collection == null) {
                throw new ConfigurationException("Invalid pagination configuration in " + name);
            }
            return new Paginate(paginate2.getInteger("size", Integer.valueOf(5)), paginate2.getString("link", "/:collection/page:page/"), collection);
        }
        if (value instanceof String) {
            String collection = (String)value;
            return new Paginate(5, "/:collection/page:page/", collection);
        }
        if (value instanceof Boolean && (paginate = (Boolean)value).booleanValue()) {
            if (defaultCollection == null) {
                throw new ConfigurationException("Invalid pagination configuration in " + name);
            }
            return new Paginate(5, "/:collection/page:page/", defaultCollection.id());
        }
        throw new ConfigurationException("Invalid pagination configuration in " + name);
    }

    private record PageToPublish(RoqUrl url, PageInfo info, JsonObject data) {
    }
}

