/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.NormalPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollections;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.TemplateData;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Vetoed;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@TemplateData
@Vetoed
public final class Site {
    private final RoqUrl url;
    private final String imagesDir;
    private final JsonObject data;
    private final List<NormalPage> pages;
    private final RoqCollections collections;
    private final LazyValue<Map<String, NormalPage>> pagesById;
    private final LazyValue<Map<String, DocumentPage>> documentsById;
    private final NormalPage page;

    public Site(RoqUrl url, String imagesDir, JsonObject data, List<NormalPage> pages, RoqCollections collections) {
        this.url = url;
        this.imagesDir = imagesDir;
        this.data = data;
        this.pages = pages;
        this.collections = collections;
        this.page = pages.stream().filter(p -> p.info().isSiteIndex()).findFirst().get();
        this.pagesById = new LazyValue(() -> pages.stream().collect(Collectors.toMap(Page::id, Function.identity())));
        this.documentsById = new LazyValue(() -> this.collections().collections().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(Page::id, Function.identity(), (a, b) -> a)));
    }

    public static Site getBeanInstance() {
        return (Site)((InstanceHandle)Arc.container().beanInstanceSupplier(Site.class, new Annotation[0]).get()).get();
    }

    public String title() {
        return this.data().getString("title");
    }

    public String description() {
        return this.data().getString("description");
    }

    public RoqUrl image() {
        String img = Page.getImgFromData(this.data());
        if (img == null) {
            return null;
        }
        return this.image(img);
    }

    public RoqUrl image(Object imageRelativePath) {
        if (imageRelativePath == null) {
            return null;
        }
        String path = String.valueOf(imageRelativePath);
        if (RoqUrl.isFullPath(path)) {
            return RoqUrl.fromRoot(null, path);
        }
        if (this.hasFile(PathUtils.join((String)"static/assets/images", (String)(path = Page.normaliseName(path, this.page.info().files().slugified()))))) {
            return this.file(PathUtils.join((String)"static/assets/images", (String)path));
        }
        return this.file(PathUtils.join((String)this.imagesDir, (String)path));
    }

    public List<String> files() {
        return this.page.info().files().names();
    }

    public boolean hasFile(Object name) {
        return this.page.info().hasFile(name);
    }

    public RoqUrl file(Object name) {
        return Page.resolvePublicFile(this.page, name);
    }

    public RoqUrl url(Object path) {
        return this.url().resolve(path);
    }

    public RoqUrl url(Object path, Object path1) {
        return this.url(path).resolve(path1);
    }

    public RoqUrl url(Object path, Object path1, Object path2) {
        return this.url(path).resolve(path1).resolve(path2);
    }

    public Page page(String sourcePath) {
        return ((Map)this.pagesById.get()).containsKey(sourcePath) ? (Page)((Map)this.pagesById.get()).get(sourcePath) : (Page)((Map)this.documentsById.get()).get(sourcePath);
    }

    public NormalPage normalPage(String sourcePath) {
        return (NormalPage)((Map)this.pagesById.get()).get(sourcePath);
    }

    public DocumentPage document(String sourcePath) {
        return (DocumentPage)((Map)this.documentsById.get()).get(sourcePath);
    }

    public RoqUrl url() {
        return this.url;
    }

    public RoqUrl imagesDirUrl() {
        return this.url().resolve(this.imagesDir);
    }

    public JsonObject data() {
        return this.data;
    }

    public List<NormalPage> pages() {
        return this.pages;
    }

    public RoqCollections collections() {
        return this.collections;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Site that = (Site)obj;
        return Objects.equals(this.url, that.url) && Objects.equals(this.imagesDir, that.imagesDir) && Objects.equals(this.data, that.data) && Objects.equals(this.pages, that.pages) && Objects.equals(this.collections, that.collections);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.imagesDir, this.data, this.pages, this.collections);
    }

    public String toString() {
        return "Site[url=" + String.valueOf(this.url) + ", imagesDirUrl=" + this.imagesDir + ", data=" + String.valueOf(this.data) + ", pages=" + String.valueOf(this.pages) + ", collections=" + String.valueOf(this.collections) + "]";
    }
}

