/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime;

import io.quarkiverse.roq.frontmatter.runtime.RoqRouteHandler;
import io.quarkiverse.roq.frontmatter.runtime.config.ConfiguredCollection;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.NormalPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.PageInfo;
import io.quarkiverse.roq.frontmatter.runtime.model.Paginator;
import io.quarkiverse.roq.frontmatter.runtime.model.RootUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollections;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Recorder
public class RoqFrontMatterRecorder {
    private final HttpBuildTimeConfig httpConfig;
    private final RoqSiteConfig config;

    public RoqFrontMatterRecorder(HttpBuildTimeConfig httpConfig, RoqSiteConfig config) {
        this.httpConfig = httpConfig;
        this.config = config;
    }

    public Supplier<RoqCollections> createRoqCollections(Map<ConfiguredCollection, List<Supplier<DocumentPage>>> collectionSuppliers) {
        return () -> {
            HashMap<String, RoqCollection> c = new HashMap<String, RoqCollection>();
            for (Map.Entry e : collectionSuppliers.entrySet()) {
                ArrayList<DocumentPage> docs = new ArrayList<DocumentPage>();
                for (Supplier v : (List)e.getValue()) {
                    docs.add((DocumentPage)v.get());
                }
                c.put(((ConfiguredCollection)e.getKey()).id(), new RoqCollection((ConfiguredCollection)e.getKey(), docs));
            }
            return new RoqCollections(Map.copyOf(c));
        };
    }

    public Supplier<NormalPage> createPage(RoqUrl url, PageInfo info, JsonObject data, Paginator paginator) {
        return () -> new NormalPage(url, info, data, paginator);
    }

    public Supplier<DocumentPage> createDocument(String collection, RoqUrl url, PageInfo info, JsonObject data, boolean hidden) {
        return () -> new DocumentPage(collection, url, info, data, hidden);
    }

    public Supplier<Site> createSite(RootUrl rootUrl, Supplier<NormalPage> indexPage, List<Supplier<NormalPage>> normalPagesSuppliers, Supplier<RoqCollections> roqCollectionsSupplier) {
        return () -> {
            ArrayList<NormalPage> pages = new ArrayList<NormalPage>();
            for (Supplier pagesSupplier : normalPagesSuppliers) {
                pages.add((NormalPage)pagesSupplier.get());
            }
            return new Site(((NormalPage)indexPage.get()).url(), this.config.imagesPath(), ((NormalPage)indexPage.get()).data(), pages, (RoqCollections)roqCollectionsSupplier.get());
        };
    }

    public Consumer<Route> initializeRoute() {
        return r -> {
            r.method(HttpMethod.GET);
            r.order(this.config.routeOrder());
        };
    }

    public Handler<RoutingContext> handler(String rootPath, Map<String, Supplier<? extends Page>> pageSuppliers) {
        return new RoqRouteHandler(rootPath, this.httpConfig, pageSuppliers);
    }

    public Handler<RoutingContext> aliasRoute(String target) {
        return ctx -> ctx.redirect(target);
    }
}

