/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime;

import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollections;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.qute.TemplateExtension;
import io.vertx.core.json.JsonArray;
import java.util.List;
import java.util.regex.Pattern;

@TemplateExtension
public class RoqTemplateExtension {
    private static final int QUTE_FALLBACK_PRIORITY = -2;
    private static final Pattern COUNT_WORDS = Pattern.compile("\\b\\w+\\b");

    public static long numberOfWords(String text) {
        return COUNT_WORDS.matcher(text).results().count();
    }

    @TemplateExtension(matchName="*", priority=-2)
    public static RoqCollection collection(RoqCollections collections, String key) {
        return collections.get(key);
    }

    public static Object readTime(Page page) {
        long count = RoqTemplateExtension.numberOfWords(page.rawContent());
        return Math.round((float)count / 200.0f);
    }

    public static String slugify(String text) {
        return PathUtils.slugify((String)text, (boolean)false, (boolean)false);
    }

    public static List<String> asStrings(Object o) {
        if (o instanceof String) {
            String i = (String)o;
            return List.of(i.split("\\h*,\\h*|\\h{2,}"));
        }
        if (o instanceof JsonArray) {
            JsonArray i = (JsonArray)o;
            return i.getList();
        }
        return List.of();
    }
}

