/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.model.RootUrl;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.qute.TemplateData;
import jakarta.enterprise.inject.Vetoed;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@TemplateData
@Vetoed
public record RoqUrl(RootUrl root, String resourcePath) {
    @Override
    public String toString() {
        return this.path();
    }

    public String path() {
        return this.path(true);
    }

    public String path(boolean encoded) {
        if (this.isExternal()) {
            return this.resourcePath();
        }
        String path = PathUtils.join((String)this.root.rootPath(), (String)this.resourcePath());
        return encoded ? RoqUrl.encode(path) : path;
    }

    private static String encode(String path) {
        try {
            return new URI(null, null, path, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String relative() {
        return this.path();
    }

    public String absolute() {
        if (this.isExternal()) {
            return this.resourcePath();
        }
        return PathUtils.join((String)this.root().url(), (String)this.path());
    }

    public String encoded() {
        return URLEncoder.encode(this.absolute(), StandardCharsets.UTF_8);
    }

    public static boolean isFullPath(String path) {
        Objects.requireNonNull(path, "path is required");
        return path.startsWith("http://") || path.startsWith("https://");
    }

    public RoqUrl resolve(Object other) {
        if (RoqUrl.isFullPath(other.toString())) {
            return new RoqUrl(null, other.toString());
        }
        return new RoqUrl(this.root(), PathUtils.join((String)this.resourcePath(), (String)PathUtils.addTrailingSlashIfNoExt((String)other.toString())));
    }

    public RoqUrl join(Object other) {
        return this.resolve(other);
    }

    public RoqUrl append(Object other) {
        return new RoqUrl(this.root(), this.resourcePath() + other.toString());
    }

    public boolean isExternal() {
        return this.root() == null;
    }

    public RoqUrl fromRoot(String path) {
        return this.root.resolve(path);
    }

    public static RoqUrl fromRoot(RootUrl root, String resourcePath) {
        if (RoqUrl.isFullPath(resourcePath)) {
            return new RoqUrl(null, resourcePath);
        }
        return new RoqUrl(root, PathUtils.addTrailingSlashIfNoExt((String)resourcePath));
    }
}

