/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.config;

import io.quarkiverse.roq.frontmatter.runtime.config.ConfiguredCollection;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="site")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface RoqSiteConfig {
    public static final String DIR_NAME_PATTERN = "^[a-zA-Z0-9._-]{1,255}$";
    public static final String CONTENT_DIR = "content";
    public static final String STATIC_DIR = "static";
    public static final String PUBLIC_DIR = "public";
    public static final String IGNORED_FILES = "**/_**,_**,.**";
    public static final List<ConfiguredCollection> DEFAULT_COLLECTIONS = List.of(new ConfiguredCollection("posts", false, false, false, ":theme/post"));

    @WithName(value="root-path")
    @WithDefault(value="/")
    public String rootPath();

    @WithName(value="url")
    public Optional<String> urlOptional();

    @WithDefault(value="1100")
    public int routeOrder();

    @WithDefault(value="**/_**,_**,.**")
    public List<String> ignoredFiles();

    @WithDefault(value=":theme/page")
    public Optional<String> pageLayout();

    @WithDefault(value="content")
    @Pattern(regexp="^[a-zA-Z0-9._-]{1,255}$")
    public @Pattern(regexp="^[a-zA-Z0-9._-]{1,255}$") String contentDir();

    @WithDefault(value="static")
    @Pattern(regexp="^[a-zA-Z0-9._-]{1,255}$")
    public @Pattern(regexp="^[a-zA-Z0-9._-]{1,255}$") String staticDir();

    @WithDefault(value="public")
    @Pattern(regexp="^[a-zA-Z0-9._-]{1,255}$")
    public @Pattern(regexp="^[a-zA-Z0-9._-]{1,255}$") String publicDir();

    @WithDefault(value="images/")
    public String imagesPath();

    @WithDefault(value="true")
    public boolean generator();

    @WithDefault(value="false")
    public boolean future();

    public Optional<String> theme();

    @WithDefault(value="false")
    public boolean draft();

    @WithDefault(value="yyyy-MM-dd[ HH:mm][:ss][ Z]")
    public String dateFormat();

    @ConfigDocDefault(value="document timezone if provided or system timezone")
    public Optional<String> timeZone();

    @WithDefault(value="true")
    public boolean slugifyFiles();

    @ConfigDocDefault(value="posts={id: post, hidden: false}")
    @WithName(value="collections")
    public Map<String, CollectionConfig> collectionsMap();

    default public List<ConfiguredCollection> collections() {
        if (this.collectionsMap().isEmpty()) {
            return DEFAULT_COLLECTIONS;
        }
        return this.collectionsMap().entrySet().stream().filter(e -> ((CollectionConfig)e.getValue()).enabled()).map(e -> new ConfiguredCollection((String)e.getKey(), false, ((CollectionConfig)e.getValue()).hidden(), ((CollectionConfig)e.getValue()).future(), ((CollectionConfig)e.getValue()).layout().orElse(null))).toList();
    }

    public static interface CollectionConfig {
        @WithParentName
        @WithDefault(value="true")
        public boolean enabled();

        @WithDefault(value="false")
        public boolean future();

        @WithDefault(value="false")
        public boolean hidden();

        public Optional<String> layout();
    }
}

