/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.exception.RoqStaticFileException;
import io.quarkiverse.roq.frontmatter.runtime.model.PageFiles;
import io.quarkiverse.roq.frontmatter.runtime.model.PageInfo;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.TemplateData;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Vetoed;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;

@TemplateData
@Vetoed
public interface Page {
    public static final String FM_TITLE = "title";
    public static final String FM_DESCRIPTION = "description";

    public PageInfo info();

    default public String id() {
        return this.info().id();
    }

    default public String rawContent() {
        return this.info().rawContent();
    }

    default public String baseFileName() {
        return this.info().sourceBaseFileName();
    }

    default public String sourceFileName() {
        return this.info().sourceFileName();
    }

    default public String sourcePath() {
        return this.info().sourceFilePath();
    }

    default public ZonedDateTime date() {
        return this.info().date();
    }

    default public String title() {
        return this.data().getString(FM_TITLE, this.sourcePath());
    }

    default public String description() {
        return this.data().getString(FM_DESCRIPTION);
    }

    default public RoqUrl image() {
        String img = Page.getImgFromData(this.data());
        if (img == null) {
            return null;
        }
        return this.image(img);
    }

    default public Site site() {
        return (Site)((InstanceHandle)Arc.container().beanInstanceSupplier(Site.class, new Annotation[0]).get()).get();
    }

    default public RoqUrl image(Object imageRelativePath) {
        if (imageRelativePath == null) {
            return null;
        }
        if (this.info().usePublicFiles()) {
            return this.site().image(imageRelativePath);
        }
        String path = String.valueOf(imageRelativePath);
        if (RoqUrl.isFullPath(path)) {
            return RoqUrl.fromRoot(null, path);
        }
        path = Page.normaliseName(path, this.info().files().slugified());
        return this.file(path);
    }

    default public List<String> files() {
        if (this.info().usePublicFiles()) {
            throw new RoqStaticFileException("Can't list attached files. Convert page '%s' to a directory (with an index) to allow attaching files.".formatted(this.sourcePath()));
        }
        return this.info().files().names();
    }

    default public boolean hasFile(Object name) {
        if (this.info().usePublicFiles()) {
            throw new RoqStaticFileException("Can't find file '%s' attached to the page. Convert page '%s' to a directory (with an index) to allow attaching files.".formatted(name, this.sourcePath()));
        }
        String f = Page.normaliseName(name, this.info().files().slugified());
        return this.info().hasFile(f);
    }

    default public RoqUrl file(Object name) {
        if (this.info().usePublicFiles()) {
            throw new RoqStaticFileException("Can't find file '%s' attached to the page. Convert page '%s' to a directory (with an index) to allow attaching files.".formatted(name, this.sourcePath()));
        }
        String dir = PathUtils.toUnixPath((String)Path.of(this.sourcePath(), new String[0]).getParent().toString());
        return Page.resolveFile(this, name, "Can't find '%s' in  '" + dir + "' which has no attached static file.", "File '%s' not found in '" + dir + "' directory (found: %s).");
    }

    public static RoqUrl resolvePublicFile(Page page, Object name) {
        return Page.resolveFile(page, name, "No file found in the public dir.", "File '%s' not found in public dir (found: %s).");
    }

    public static RoqUrl resolveFile(Page page, Object name, String missingResourceMessage, String notFoundMessage) {
        if (name == null) {
            return null;
        }
        if (!page.info().hasFiles()) {
            throw new RoqStaticFileException(missingResourceMessage.formatted(name));
        }
        String f = Page.normaliseName(name, page.info().files().slugified());
        if (page.info().hasFile(f)) {
            return page.url().resolve(f);
        }
        throw new RoqStaticFileException(notFoundMessage.formatted(name, String.join((CharSequence)", ", page.info().files().names())));
    }

    public static String normaliseName(Object name, boolean slugify) {
        String clean = String.valueOf(name).replace("./", "");
        if (slugify) {
            return PageFiles.slugifyFile(clean);
        }
        return clean;
    }

    public RoqUrl url();

    public JsonObject data();

    default public Object data(String name) {
        if (this.data().containsKey(name)) {
            return this.data().getValue(name);
        }
        return null;
    }

    public static String getImgFromData(JsonObject data) {
        return data.getString("img", data.getString("image", data.getString("picture")));
    }
}

