/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.model.PageFiles;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.qute.TemplateData;
import jakarta.enterprise.inject.Vetoed;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.function.Function;

@TemplateData
@Vetoed
public record PageInfo(String id, boolean draft, String dateString, String rawContent, String sourceFilePath, String generatedTemplateId, PageFiles files, boolean isHtml, boolean isSiteIndex) {
    public static final Set<String> HTML_OUTPUT_EXTENSIONS = Set.of("md", "markdown", "html", "htm", "xhtml", "asciidoc", "adoc");

    public static PageInfo create(String id, boolean draft, String dateString, String rawContent, String sourcePath, String quteTemplateId, PageFiles files, boolean isHtml, boolean isSiteIndex) {
        return new PageInfo(id, draft, dateString, rawContent, sourcePath, quteTemplateId, files, isHtml, isSiteIndex);
    }

    public PageInfo changeId(String id) {
        return new PageInfo(id, this.draft(), this.dateString(), this.rawContent(), this.sourceFilePath(), this.generatedTemplateId(), this.isSiteIndex() ? null : this.files(), this.isHtml(), false);
    }

    public PageInfo changeIds(Function<String, String> function) {
        return new PageInfo(function.apply(this.id()), this.draft(), this.dateString(), this.rawContent(), this.sourceFilePath(), function.apply(this.generatedTemplateId()), this.isSiteIndex() ? null : this.files(), this.isHtml(), false);
    }

    public ZonedDateTime date() {
        return this.dateString != null ? ZonedDateTime.parse(this.dateString) : null;
    }

    public boolean usePublicFiles() {
        return this.isSiteIndex || this.files() == null;
    }

    public String sourceFileName() {
        return PathUtils.fileName((String)this.sourceFilePath);
    }

    public String sourceBaseFileName() {
        return PathUtils.removeExtension((String)this.sourceFileName());
    }

    public String sourceFileExtension() {
        return PathUtils.getExtension((String)this.sourceFileName());
    }

    public boolean isIndex() {
        return this.isHtml && "index".equals(this.sourceBaseFileName());
    }

    public boolean hasFiles() {
        return !this.files.isEmpty();
    }

    public boolean hasFile(Object name) {
        if (name == null) {
            return false;
        }
        if (!this.hasFiles()) {
            return false;
        }
        return this.files().contains(name);
    }
}

