/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.qute.TemplateData;
import jakarta.enterprise.inject.Vetoed;

@TemplateData
@Vetoed
public record RootUrl(String url, String rootPath) {
    public RootUrl(String url, String rootPath) {
        this.url = url;
        this.rootPath = PathUtils.prefixWithSlash((String)PathUtils.addTrailingSlashIfNoExt((String)rootPath));
    }

    public String absolute() {
        return PathUtils.join((String)this.url, (String)this.rootPath);
    }

    public String path() {
        return this.rootPath();
    }

    public String relative() {
        return this.rootPath();
    }

    public RoqUrl resolve(String path) {
        return RoqUrl.fromRoot(this, path);
    }

    public RoqUrl join(String path) {
        return this.resolve(path);
    }

    @Override
    public String toString() {
        return this.rootPath();
    }
}

