/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.config.ConfiguredCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.Paginator;
import io.quarkus.qute.TemplateData;
import jakarta.enterprise.inject.Vetoed;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@TemplateData
@Vetoed
public class RoqCollection
extends ArrayList<DocumentPage> {
    private final ConfiguredCollection collection;
    public static final Comparator<DocumentPage> BY_DATE = Comparator.comparing(Page::date, Comparator.nullsLast(Comparator.naturalOrder())).reversed();

    public RoqCollection(ConfiguredCollection collection, List<DocumentPage> documents) {
        super(documents.stream().sorted(BY_DATE).toList());
        this.collection = collection;
    }

    public String id() {
        return this.collection.id();
    }

    public boolean derived() {
        return this.collection.derived();
    }

    public boolean hidden() {
        return this.collection.hidden();
    }

    public ConfiguredCollection collection() {
        return this.collection;
    }

    public DocumentPage nextPage(DocumentPage page) {
        int i = this.indexOf(page);
        if (i == -1 || i >= this.size() - 1) {
            return null;
        }
        return (DocumentPage)this.get(i + 1);
    }

    public DocumentPage previousPage(DocumentPage page) {
        int i = this.indexOf(page);
        if (i <= 0) {
            return null;
        }
        return (DocumentPage)this.get(i - 1);
    }

    public DocumentPage prevPage(DocumentPage page) {
        return this.previousPage(page);
    }

    public List<DocumentPage> paginated(Paginator paginator) {
        if (paginator == null) {
            return this;
        }
        int zeroBasedCurrent = paginator.currentIndex() - 1;
        return this.subList(zeroBasedCurrent * paginator.limit(), Math.min(this.size(), zeroBasedCurrent * paginator.limit() + paginator.limit()));
    }

    public List<DocumentPage> randomise() {
        ArrayList<DocumentPage> list = new ArrayList<DocumentPage>(this);
        Collections.shuffle(list);
        return list;
    }

    public List<DocumentPage> future() {
        return this.stream().filter(d -> d.date().isAfter(ZonedDateTime.now())).toList();
    }

    public String layout() {
        return this.collection.layout();
    }

    public List<DocumentPage> past() {
        return this.stream().filter(d -> d.date().isBefore(ZonedDateTime.now())).toList();
    }

    public List<Object> by(String ... keys) {
        return this.stream().flatMap(page -> Arrays.stream(keys).map(page::data).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    public Map<Object, List<Page>> group(String ... keys) {
        LinkedHashMap<Object, List<Page>> resultMap = new LinkedHashMap<Object, List<Page>>();
        for (Page page : this) {
            for (String key : keys) {
                Object value = page.data(key);
                if (value == null) continue;
                resultMap.computeIfAbsent(value, k -> new ArrayList()).add(page);
            }
        }
        return resultMap;
    }
}

