/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime;

import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.RoutingUtils;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class RoqRouteHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(RoqRouteHandler.class);
    private final String rootPath;
    private final List<String> compressMediaTypes;
    private final Map<String, Supplier<? extends Page>> pages;
    private final Map<String, Page> extractedPaths;
    private final Event<SecurityIdentity> securityIdentityEvent;
    private final CurrentIdentityAssociation currentIdentity;
    private final CurrentVertxRequest currentVertxRequest;
    private final ManagedContext requestContext;
    private final LazyValue<TemplateProducer> templateProducer;
    private final LazyValue<Site> site;

    public RoqRouteHandler(String rootPath, VertxHttpBuildTimeConfig httpBuildTimeConfig, Map<String, Supplier<? extends Page>> pages) {
        this.rootPath = rootPath;
        this.pages = pages;
        this.compressMediaTypes = httpBuildTimeConfig.enableCompression() ? httpBuildTimeConfig.compressMediaTypes().orElse(List.of()) : null;
        this.extractedPaths = new ConcurrentHashMap<String, Page>();
        ArcContainer container = Arc.container();
        this.securityIdentityEvent = container.beanManager().getEvent().select(SecurityIdentity.class, new Annotation[0]);
        this.currentVertxRequest = (CurrentVertxRequest)container.instance(CurrentVertxRequest.class, new Annotation[0]).get();
        this.requestContext = container.requestContext();
        this.currentIdentity = (CurrentIdentityAssociation)container.instance(CurrentIdentityAssociation.class, new Annotation[0]).get();
        this.templateProducer = new LazyValue(() -> (TemplateProducer)Arc.container().instance(TemplateProducer.class, new Annotation[0]).get());
        this.site = new LazyValue(() -> (Site)Arc.container().instance(Site.class, new Annotation[0]).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext rc) {
        QuarkusHttpUser user = (QuarkusHttpUser)rc.user();
        if (this.requestContext.isActive()) {
            this.processCurrentIdentity(rc, user);
            this.handlePage(rc);
        } else {
            try {
                this.requestContext.activate();
                this.currentVertxRequest.setCurrent(rc);
                this.processCurrentIdentity(rc, user);
                InjectableContext.ContextState endState = this.requestContext.getState();
                rc.addEndHandler(result -> this.requestContext.destroy(endState));
                this.handlePage(rc);
            }
            finally {
                this.requestContext.deactivate();
            }
        }
    }

    private void processCurrentIdentity(RoutingContext rc, QuarkusHttpUser user) {
        if (this.currentIdentity != null) {
            if (user != null) {
                SecurityIdentity identity = user.getSecurityIdentity();
                this.currentIdentity.setIdentity(identity);
            } else {
                this.currentIdentity.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)rc, null));
            }
        }
        if (user != null) {
            this.securityIdentityEvent.fire((Object)user.getSecurityIdentity());
        }
    }

    private void handlePage(RoutingContext rc) {
        String requestPath = RoutingUtils.resolvePath((RoutingContext)rc);
        LOG.debugf("Handle page: %s", (Object)requestPath);
        Page page = this.extractedPaths.computeIfAbsent(requestPath, this::extractTemplatePath);
        if (page != null) {
            TemplateInstance originalInstance;
            String templateId = PathUtils.removeExtension((String)page.info().generatedTemplateId());
            Template template = ((TemplateProducer)this.templateProducer.get()).getInjectableTemplate(templateId);
            TemplateInstance instance = originalInstance = template.instance();
            List acceptableTypes = rc.parsedHeaders().accept();
            Variant selected = this.trySelectVariant(rc, originalInstance, acceptableTypes);
            if (selected != null) {
                String contentEncoding;
                instance.setAttribute("selectedVariant", (Object)selected);
                rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)selected.getContentType());
                if (this.compressMediaTypes != null && this.compressMediaTypes.contains(selected.getContentType()) && (contentEncoding = rc.response().headers().get(HttpHeaders.CONTENT_ENCODING)) != null && HttpHeaders.IDENTITY.toString().equals(contentEncoding)) {
                    rc.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
                }
            }
            if (selected == null && !acceptableTypes.isEmpty()) {
                LOG.errorf("Appropriate template variant not found %s: %s", acceptableTypes.stream().map(ParsedHeaderValue::rawValue).collect(Collectors.toList()), (Object)rc.request().path());
                rc.response().setStatusCode(406).end();
            } else {
                instance.data("page", (Object)page);
                instance.data("site", this.site.get());
                instance.renderAsync().whenComplete((r, t) -> {
                    if (t != null) {
                        Throwable rootCause = this.rootCause((Throwable)t);
                        LOG.errorf("Error occurred while rendering the template [%s]: %s", (Object)page.id(), (Object)rootCause.toString());
                        rc.fail(rootCause);
                    } else {
                        rc.response().setStatusCode(200).end(r);
                    }
                });
            }
        } else {
            LOG.debugf("Template page not found: %s", (Object)rc.request().path());
            rc.next();
        }
    }

    private Throwable rootCause(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    private Variant trySelectVariant(RoutingContext rc, TemplateInstance instance, List<MIMEHeader> acceptableTypes) {
        Object variantsAttr = instance.getAttribute("variants");
        if (variantsAttr != null) {
            List variants = (List)variantsAttr;
            if (!acceptableTypes.isEmpty()) {
                for (MIMEHeader accept : acceptableTypes) {
                    accept.value();
                    for (Variant variant : variants) {
                        if (!new ContentType(variant.getContentType()).matches(accept.component(), accept.subComponent())) continue;
                        return variant;
                    }
                }
            }
        }
        return null;
    }

    private Page extractTemplatePath(String path) {
        String link = PathUtils.addTrailingSlashIfNoExt((String)(path = PathUtils.removeLeadingSlash((String)path)));
        if (this.pages.containsKey(link)) {
            return this.pages.get(link).get();
        }
        return null;
    }

    static final class ContentType {
        private static final String WILDCARD = "*";
        final String type;
        final String subtype;

        ContentType(String value) {
            int slash = value.indexOf(47);
            this.type = value.substring(0, slash);
            int semicolon = value.indexOf(59);
            this.subtype = semicolon != -1 ? value.substring(slash + 1, semicolon) : value.substring(slash + 1);
        }

        boolean matches(String otherType, String otherSubtype) {
            return !(!this.type.equals(otherType) && !this.type.equals(WILDCARD) && !otherType.equals(WILDCARD) || !this.subtype.equals(otherSubtype) && !this.subtype.equals(WILDCARD) && !otherSubtype.equals(WILDCARD));
        }
    }
}

