/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime;

import io.quarkiverse.roq.frontmatter.runtime.RoqTemplates;
import io.quarkiverse.roq.frontmatter.runtime.model.SourceFile;
import io.quarkiverse.roq.frontmatter.runtime.model.Sources;
import io.quarkiverse.roq.frontmatter.runtime.model.TemplateSource;
import io.quarkus.qute.EngineBuilder;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@ApplicationScoped
public class RoqQuteEngineObserver {
    private final Map<String, SourceFile> templatePathMapping;

    @Inject
    public RoqQuteEngineObserver(Sources sources) {
        this.templatePathMapping = RoqQuteEngineObserver.initTemplatePathMapping(sources);
    }

    void configureEngine(@Observes EngineBuilder builder) {
        builder.addParserHook(c -> {
            if (RoqTemplates.isLayoutSourceTemplate(c.getTemplateId())) {
                c.addContentFilter(s -> "");
                return;
            }
        });
        builder.addTemplateInstanceInitializer(templateInstance -> {
            String templateId = RoqTemplates.resolveOriginalTemplateId(templateInstance.getTemplate().getId());
            templateInstance.setAttribute("templateId", (Object)templateId);
            if (this.templatePathMapping.containsKey(templateId)) {
                SourceFile sourceFile = this.templatePathMapping.get(templateId);
                templateInstance.setAttribute("sourcePath", (Object)sourceFile.absolutePath());
                templateInstance.setAttribute("sourceRootPath", (Object)sourceFile.siteDirPath());
            }
        });
    }

    private static Map<String, SourceFile> initTemplatePathMapping(Sources sources) {
        if (sources == null) {
            return new HashMap<String, SourceFile>();
        }
        return sources.list().stream().collect(Collectors.toMap(TemplateSource::generatedQuteId, TemplateSource::file, (a, b) -> a));
    }
}

