/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime;

import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollections;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.qute.TemplateExtension;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.json.JsonArray;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TemplateExtension
public class RoqTemplateExtension {
    private static final int QUTE_FALLBACK_PRIORITY = -2;
    private static final Pattern COUNT_WORDS = Pattern.compile("\\b\\w+\\b");
    private static final Pattern STRIP_HTML_PATTERN = Pattern.compile("<[^>]*>");

    public static long numberOfWords(String text) {
        return COUNT_WORDS.matcher(text).results().count();
    }

    @TemplateExtension(matchName="*", priority=-2)
    public static RoqCollection collection(RoqCollections collections, String key) {
        return collections.get(key);
    }

    public static Object readTime(Page page) {
        String text = RoqTemplateExtension.stripHtml(page.site().pageContent(page));
        long count = RoqTemplateExtension.numberOfWords(text);
        return RoqTemplateExtension.ceilDiv(count, 200L);
    }

    public static String contentAbstract(Page page) {
        return RoqTemplateExtension.contentAbstract(page, 75);
    }

    public static String contentAbstract(Page page, int limit) {
        return RoqTemplateExtension.contentAbstract(page.site().pageContent(page), limit);
    }

    public static String contentAbstract(String htmlContent, int limit) {
        return RoqTemplateExtension.wordLimit(RoqTemplateExtension.stripHtml(htmlContent), limit);
    }

    public static String stripHtml(String html) {
        if (html == null) {
            return null;
        }
        return STRIP_HTML_PATTERN.matcher(html).replaceAll("");
    }

    public static String wordLimit(String text, int limit) {
        Matcher m = COUNT_WORDS.matcher(text);
        int count = 0;
        int end = -1;
        while (m.find()) {
            if (++count != limit) continue;
            end = m.end();
            break;
        }
        if (end == -1 || end >= text.length()) {
            return text;
        }
        return text.substring(0, end).trim() + "...";
    }

    public static String slugify(String text) {
        return PathUtils.slugify((String)text, (boolean)false, (boolean)false);
    }

    public static List<String> asStrings(Object o) {
        if (o instanceof String) {
            String i = (String)o;
            return Arrays.stream(i.split("[, \t;]")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
        if (o instanceof JsonArray) {
            JsonArray i = (JsonArray)o;
            return i.getList();
        }
        return List.of();
    }

    public static String mimeType(String fileName) {
        return MimeMapping.getMimeTypeForFilename((String)fileName);
    }

    private static long ceilDiv(long x, long y) {
        long q = x / y;
        if ((x ^ y) >= 0L && q * y != x) {
            return q + 1L;
        }
        return q;
    }
}

