/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.PageSource;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.TemplateData;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Vetoed;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.StringJoiner;

@TemplateData
@Vetoed
public final class DocumentPage
extends Page {
    private final String collectionId;
    private final boolean hidden;

    public DocumentPage(String collectionId, RoqUrl url, PageSource source, JsonObject data, boolean hidden) {
        super(url, source, data);
        this.collectionId = collectionId;
        this.hidden = hidden;
    }

    public RoqCollection collection() {
        return ((Site)((InstanceHandle)Arc.container().beanInstanceSupplier(Site.class, new Annotation[0]).get()).get()).collections().resolveCollection(this);
    }

    public DocumentPage nextPage() {
        return this.collection().nextPage(this);
    }

    public DocumentPage next() {
        return this.nextPage();
    }

    public DocumentPage previous() {
        return this.previousPage();
    }

    public DocumentPage prev() {
        return this.previousPage();
    }

    public DocumentPage previousPage() {
        return this.collection().previousPage(this);
    }

    public DocumentPage prevPage() {
        return this.collection().previousPage(this);
    }

    public String collectionId() {
        return this.collectionId;
    }

    public boolean hidden() {
        return this.hidden;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DocumentPage that = (DocumentPage)o;
        return this.hidden == that.hidden && Objects.equals(this.collectionId, that.collectionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.collectionId, this.hidden);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DocumentPage.class.getSimpleName() + "[", "]").add("collectionId='" + this.collectionId + "'").add("hidden=" + this.hidden).toString();
    }
}

