/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.exception.RoqStaticFileException;
import io.quarkiverse.roq.frontmatter.runtime.model.PageSource;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkiverse.roq.frontmatter.runtime.utils.Pages;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.TemplateData;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Vetoed;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@TemplateData
@Vetoed
public class Page {
    public static final String FM_TITLE = "title";
    public static final String FM_DESCRIPTION = "description";
    private final RoqUrl url;
    private final JsonObject data;
    private final PageSource source;

    protected Page(RoqUrl url, PageSource source, JsonObject data) {
        this.url = url;
        this.data = data;
        this.source = source;
    }

    public PageSource source() {
        return this.source;
    }

    public boolean draft() {
        return this.source().draft();
    }

    public String id() {
        return this.source().id();
    }

    public String rawContent() {
        return this.source().rawContent();
    }

    public String baseFileName() {
        return this.source().baseFileName();
    }

    public String sourceFileName() {
        return this.source().fileName();
    }

    public String sourcePath() {
        return this.source().path();
    }

    public ZonedDateTime date() {
        return this.source().date();
    }

    public String title() {
        return this.data().getString(FM_TITLE, this.sourcePath());
    }

    public String description() {
        return this.data().getString(FM_DESCRIPTION);
    }

    public RoqUrl image() {
        String img = Pages.getImgFromData(this.data());
        if (img == null) {
            return null;
        }
        return this.image(img);
    }

    public Site site() {
        return (Site)((InstanceHandle)Arc.container().beanInstanceSupplier(Site.class, new Annotation[0]).get()).get();
    }

    public RoqUrl image(Object name) {
        if (name == null) {
            return null;
        }
        if (this.source().usePublicFiles()) {
            return this.site().image(name);
        }
        String path = String.valueOf(name);
        if (RoqUrl.isFullPath(path)) {
            return RoqUrl.fromRoot(null, path);
        }
        path = Pages.normaliseName(path, this.source().files().slugified());
        return this.file(path);
    }

    public boolean imageExists(Object name) {
        if (name == null) {
            return false;
        }
        String path = String.valueOf(name);
        if (this.source().usePublicFiles()) {
            return this.site().imageExists(path);
        }
        path = Pages.normaliseName(path, this.source().files().slugified());
        return this.fileExists(path);
    }

    public List<String> files() {
        if (this.source().usePublicFiles()) {
            throw new RoqStaticFileException("Can't list attached files. Convert page '%s' to a directory (with an index) to allow attaching files.".formatted(this.sourcePath()));
        }
        return this.source().files().names();
    }

    public boolean fileExists(Object name) {
        if (this.source().usePublicFiles()) {
            throw new RoqStaticFileException("Can't find file '%s' attached to the page. Convert page '%s' to a directory (with an index) to allow attaching files.".formatted(name, this.sourcePath()));
        }
        String f = Pages.normaliseName(name, this.source().files().slugified());
        return this.source().fileExists(f);
    }

    public RoqUrl file(Object name) {
        if (!this.source().isIndex()) {
            throw new RoqStaticFileException("Only page directories with an index can have attached files. Then add '%s' to the page directory to fix this error.".formatted(name, this.sourcePath()));
        }
        Path path = Path.of(this.sourcePath(), new String[0]);
        String dir = path.getParent() == null ? "/" : PathUtils.toUnixPath((String)path.getParent().toString());
        return Pages.resolveFile(this, name, "Can't find '%s' in  '" + dir + "' which has no attached static file.", "File '%s' not found in '" + dir + "' directory (found: %s).");
    }

    public RoqUrl url() {
        return this.url;
    }

    public JsonObject data() {
        return this.data;
    }

    public Object data(String name) {
        if (this.data().containsKey(name)) {
            return this.data().getValue(name);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return Objects.equals(this.url, page.url) && Objects.equals(this.data, page.data) && Objects.equals(this.source, page.source);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.data, this.source);
    }

    public String toString() {
        return new StringJoiner(", ", Page.class.getSimpleName() + "[", "]").add("url=" + String.valueOf(this.url)).add("data=" + String.valueOf(this.data)).add("source=" + String.valueOf(this.source)).toString();
    }
}

