/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.model.PageFiles;
import io.quarkiverse.roq.frontmatter.runtime.model.SourceFile;
import io.quarkiverse.roq.frontmatter.runtime.model.TemplateSource;
import io.quarkus.qute.TemplateData;
import jakarta.enterprise.inject.Vetoed;
import java.time.ZonedDateTime;

@TemplateData
@Vetoed
public record PageSource(TemplateSource template, boolean draft, String dateString, PageFiles files) {
    public PageSource changeId(String id) {
        return new PageSource(this.template().changeId(id), this.draft, this.dateString, this.isSiteIndex() ? null : this.files);
    }

    public String id() {
        return this.template.id();
    }

    public String generatedQuteId() {
        return this.template.generatedQuteId();
    }

    public String path() {
        return this.template.path();
    }

    public SourceFile file() {
        return this.template.file();
    }

    public String rawContent() {
        return this.template.rawContent();
    }

    public String markup() {
        return this.template.markup();
    }

    public String fileName() {
        return this.template.fileName();
    }

    public String baseFileName() {
        return this.template.baseFileName();
    }

    public String extension() {
        return this.template.extension();
    }

    public boolean isSiteIndex() {
        return this.template.isSiteIndex();
    }

    public boolean isIndex() {
        return this.template.isIndex();
    }

    public boolean isTargetHtml() {
        return this.template.isTargetHtml();
    }

    public boolean hasFiles() {
        return this.files != null && !this.files.isEmpty();
    }

    public boolean hasNoFiles() {
        return this.files == null || this.files.isEmpty();
    }

    public boolean fileExists(Object name) {
        if (name == null) {
            return false;
        }
        if (this.hasNoFiles()) {
            return false;
        }
        return this.files().contains(name);
    }

    public ZonedDateTime date() {
        return this.dateString != null ? ZonedDateTime.parse(this.dateString) : null;
    }

    public boolean usePublicFiles() {
        return this.isSiteIndex() || this.hasNoFiles();
    }
}

