/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.frontmatter.runtime.model;

import io.quarkiverse.roq.frontmatter.runtime.RoqTemplates;
import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.NormalPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollections;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.frontmatter.runtime.utils.Pages;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateData;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Vetoed;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@TemplateData
@Vetoed
public final class Site {
    private static final Logger LOG = Logger.getLogger(Site.class);
    private final RoqUrl url;
    private final String imagesDir;
    private final JsonObject data;
    private final List<NormalPage> pages;
    private final RoqCollections collections;
    private final LazyValue<Map<String, NormalPage>> pagesById;
    private final LazyValue<Map<String, DocumentPage>> documentsById;
    private final NormalPage page;
    private final Map<Page, String> pageContentCache = new ConcurrentHashMap<Page, String>();
    private final List<Page> allPages;

    public Site(RoqUrl url, String imagesDir, JsonObject data, List<NormalPage> pages, RoqCollections collections) {
        this.url = url;
        this.imagesDir = imagesDir;
        this.data = data;
        this.pages = pages;
        this.collections = collections;
        this.page = pages.stream().filter(p -> p.source().isSiteIndex()).findFirst().orElseThrow();
        this.pagesById = new LazyValue(() -> pages.stream().collect(Collectors.toMap(Page::id, Function.identity())));
        this.documentsById = new LazyValue(() -> this.collections().collections().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(Page::id, Function.identity(), (a, b) -> a)));
        this.allPages = Site.getAllPages(pages, collections);
    }

    public List<Page> allPages() {
        return this.allPages;
    }

    public String title() {
        return this.data().getString("title");
    }

    public String description() {
        return this.data().getString("description");
    }

    public RoqUrl image() {
        String img = Pages.getImgFromData(this.data());
        if (img == null) {
            return null;
        }
        return this.image(img);
    }

    public RoqUrl image(Object name) {
        if (name == null) {
            return null;
        }
        String path = String.valueOf(name);
        if (RoqUrl.isFullPath(path)) {
            return RoqUrl.fromRoot(null, path);
        }
        if (this.fileExists(PathUtils.join((String)"static/assets/images", (String)(path = Pages.normaliseName(path, this.page.source().files().slugified()))))) {
            return this.file(PathUtils.join((String)"static/assets/images", (String)path));
        }
        return this.file(PathUtils.join((String)this.imagesDir, (String)path));
    }

    public boolean imageExists(String name) {
        String path = String.valueOf(name);
        if (this.fileExists(PathUtils.join((String)"static/assets/images", (String)(path = Pages.normaliseName(path, this.page.source().files().slugified()))))) {
            return true;
        }
        return this.fileExists(PathUtils.join((String)this.imagesDir, (String)path));
    }

    public List<String> files() {
        return this.page.source().files().names();
    }

    public boolean fileExists(Object name) {
        return this.page.source().fileExists(name);
    }

    public RoqUrl file(Object name) {
        return Pages.resolvePublicFile(this.page, name);
    }

    public RoqUrl url(Object path) {
        return this.url().resolve(path);
    }

    public RoqUrl url(Object path, Object path1) {
        return this.url(path).resolve(path1);
    }

    public RoqUrl url(Object path, Object path1, Object path2) {
        return this.url(path).resolve(path1).resolve(path2);
    }

    public Page page(String sourcePath) {
        return ((Map)this.pagesById.get()).containsKey(sourcePath) ? (Page)((Map)this.pagesById.get()).get(sourcePath) : (Page)((Map)this.documentsById.get()).get(sourcePath);
    }

    public NormalPage normalPage(String sourcePath) {
        return (NormalPage)((Map)this.pagesById.get()).get(sourcePath);
    }

    public DocumentPage document(String sourcePath) {
        return (DocumentPage)((Map)this.documentsById.get()).get(sourcePath);
    }

    public RoqUrl url() {
        return this.url;
    }

    public RoqUrl imagesDirUrl() {
        return this.url().resolve(this.imagesDir);
    }

    public JsonObject data() {
        return this.data;
    }

    public List<NormalPage> pages() {
        return this.pages;
    }

    public RoqCollections collections() {
        return this.collections;
    }

    public String pageContent(Page page) {
        try {
            return this.pageContentCache.computeIfAbsent(page, p -> {
                String id;
                Engine engine = (Engine)Arc.container().instance(Engine.class, new Annotation[0]).get();
                Template template = engine.getTemplate(id = RoqTemplates.resolveGeneratedContentTemplateId(page.source().generatedQuteId()));
                if (template == null) {
                    return "";
                }
                return template.render(Map.of("page", p, "site", this));
            });
        }
        catch (Exception e) {
            if (!(e instanceof IllegalStateException) || !e.getMessage().contains("Recursive")) {
                LOG.warnf((Throwable)e, "Failed to render page content for file '%s'.", (Object)page.source().file().absolutePath());
            }
            return "";
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Site site = (Site)o;
        return Objects.equals(this.url, site.url) && Objects.equals(this.imagesDir, site.imagesDir) && Objects.equals(this.data, site.data) && Objects.equals(this.page, site.page) && Objects.equals(this.pageContentCache, site.pageContentCache) && Objects.equals(this.allPages, site.allPages);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.imagesDir, this.data, this.page, this.pageContentCache, this.allPages);
    }

    public String toString() {
        return new StringJoiner(", ", Site.class.getSimpleName() + "[", "]").add("url=" + String.valueOf(this.url)).add("imagesDir='" + this.imagesDir + "'").add("data=" + String.valueOf(this.data)).add("page=" + String.valueOf(this.page)).add("pageContentCache=" + String.valueOf(this.pageContentCache)).add("allPages=" + String.valueOf(this.allPages)).toString();
    }

    private static ArrayList<Page> getAllPages(List<NormalPage> pages, RoqCollections collections) {
        ArrayList<Page> allPages = new ArrayList<Page>(pages);
        for (RoqCollection value : collections.collections().values()) {
            allPages.addAll(value);
        }
        return allPages;
    }
}

