/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.generator.deployment;

import io.quarkiverse.roq.generator.deployment.BuildSelectionBuildItem;
import io.quarkiverse.roq.generator.deployment.items.SelectedPathBuildItem;
import io.quarkiverse.roq.generator.runtime.ConfiguredPathsProvider;
import io.quarkiverse.roq.generator.runtime.Origin;
import io.quarkiverse.roq.generator.runtime.RoqGenerator;
import io.quarkiverse.roq.generator.runtime.RoqGeneratorConfig;
import io.quarkiverse.roq.generator.runtime.RoqGeneratorRecorder;
import io.quarkiverse.roq.generator.runtime.RoqSelection;
import io.quarkiverse.roq.generator.runtime.SelectedPath;
import io.quarkiverse.roq.generator.runtime.StaticFile;
import io.quarkiverse.roq.generator.runtime.devui.RoqGeneratorJsonRPCService;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.paths.PathVisit;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.spi.GeneratedStaticResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.StaticResourcesBuildItem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class RoqGeneratorProcessor {
    private static final String FEATURE = "roq-generator";

    RoqGeneratorProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem create(CurateOutcomeBuildItem bi) {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Roq Generator selection")).componentLink("qwc-roq-generator.js").icon("font-awesome-solid:link")).dynamicLabelJsonRPCMethodName("getRoqCount"));
        return pageBuildItem;
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCServiceForCache() {
        return new JsonRPCProvidersBuildItem(RoqGeneratorJsonRPCService.class);
    }

    @BuildStep
    void produceBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(RoqGenerator.class));
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ConfiguredPathsProvider.class));
    }

    @BuildStep
    public BuildSelectionBuildItem initBuildSelection(RoqGeneratorConfig config, List<GeneratedStaticResourceBuildItem> generatedStaticResources, List<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpoints, List<SelectedPathBuildItem> selectedPaths, StaticResourcesBuildItem staticResourcesBuildItem) {
        HashSet<String> staticPaths = new HashSet<String>();
        if (staticResourcesBuildItem != null) {
            staticPaths.addAll(staticResourcesBuildItem.getPaths().stream().map(PathUtils::prefixWithSlash).toList());
        }
        if (notFoundPageDisplayableEndpoints != null) {
            staticPaths.addAll(notFoundPageDisplayableEndpoints.stream().filter(Predicate.not(NotFoundPageDisplayableEndpointBuildItem::isAbsolutePath)).map(NotFoundPageDisplayableEndpointBuildItem::getEndpoint).map(PathUtils::prefixWithSlash).toList());
        }
        Map<String, GeneratedStaticResourceBuildItem> generatedStaticResourcesMap = generatedStaticResources.stream().collect(Collectors.toMap(GeneratedStaticResourceBuildItem::getEndpoint, Function.identity()));
        Map<String, String> selectedPathsFromBuildItems = selectedPaths.stream().collect(Collectors.toMap(SelectedPathBuildItem::path, SelectedPathBuildItem::outputPath));
        HashMap<String, StaticFile> staticFiles = new HashMap<String, StaticFile>();
        RoqSelection buildSelectedPaths = this.getSelectedPaths(config, selectedPathsFromBuildItems, generatedStaticResourcesMap, staticPaths, staticFiles);
        return new BuildSelectionBuildItem(staticFiles, buildSelectedPaths);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initStaticFiles(BuildSelectionBuildItem buildSelection, RoqGeneratorRecorder recorder) {
        recorder.setStaticFiles(buildSelection.staticFiles());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initSelection(BuildSelectionBuildItem buildSelection, OutputTargetBuildItem outputTarget, RoqGeneratorRecorder recorder) {
        recorder.setBuildSelectedPaths(buildSelection.selectedPaths());
        recorder.setOutputTarget(outputTarget.getOutputDirectory().toAbsolutePath().toString());
    }

    private RoqSelection getSelectedPaths(RoqGeneratorConfig config, Map<String, String> selectedPathsFromBuildItem, Map<String, GeneratedStaticResourceBuildItem> generatedStaticResourcesMap, Set<String> staticPaths, Map<String, StaticFile> staticFiles) {
        ArrayList<SelectedPath> selectedPaths = new ArrayList<SelectedPath>();
        for (Map.Entry entry : config.customPaths().entrySet()) {
            String path = PathUtils.prefixWithSlash((String)((String)entry.getKey()));
            RoqGeneratorProcessor.addStaticFileIfPresent(generatedStaticResourcesMap, path, staticFiles);
            selectedPaths.add(SelectedPath.builder().path(path).outputPath((String)entry.getValue()).source(Origin.CONFIG).build());
        }
        for (String string : config.paths().orElse(List.of())) {
            if (!RoqGeneratorProcessor.isGlobPattern(string) && string.startsWith("/")) {
                RoqGeneratorProcessor.addStaticFileIfPresent(generatedStaticResourcesMap, string, staticFiles);
                selectedPaths.add(SelectedPath.builder().path(string).source(Origin.CONFIG).build());
                continue;
            }
            if (staticPaths == null) continue;
            for (String staticPath : staticPaths) {
                String path = PathUtils.prefixWithSlash((String)staticPath);
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + string);
                if (!matcher.matches(Path.of(path, new String[0]))) continue;
                RoqGeneratorProcessor.addStaticFileIfPresent(generatedStaticResourcesMap, path, staticFiles);
                selectedPaths.add(SelectedPath.builder().source(Origin.CONFIG).path(path).build());
            }
        }
        for (Map.Entry<Object, Object> entry : selectedPathsFromBuildItem.entrySet()) {
            selectedPaths.add(SelectedPath.builder().source(Origin.BUILD_ITEM).path((String)entry.getKey()).outputPath((String)entry.getValue()).build());
            RoqGeneratorProcessor.addStaticFileIfPresent(generatedStaticResourcesMap, (String)entry.getKey(), staticFiles);
        }
        return new RoqSelection(selectedPaths);
    }

    private static void addStaticFileIfPresent(Map<String, GeneratedStaticResourceBuildItem> generatedStaticResourcesMap, String path, Map<String, StaticFile> staticFiles) {
        if (generatedStaticResourcesMap.containsKey(path)) {
            GeneratedStaticResourceBuildItem generatedItem = generatedStaticResourcesMap.get(path);
            if (generatedItem.isFile() && generatedItem.getFile().getFileSystem().provider().getScheme().equals("file")) {
                staticFiles.put(path, new StaticFile(generatedItem.getFileAbsolutePath(), StaticFile.FetchType.FILE));
            } else {
                staticFiles.put(path, new StaticFile("META-INF/resources" + generatedItem.getEndpoint(), StaticFile.FetchType.CLASSPATH));
            }
        } else {
            Object resourceName = !"/".equals(path) ? "META-INF/resources" + path : "META-INF/resources/index.html";
            QuarkusClassLoader.visitRuntimeResources((String)resourceName, arg_0 -> RoqGeneratorProcessor.lambda$addStaticFileIfPresent$0(staticFiles, path, (String)resourceName, arg_0));
        }
    }

    private static boolean isGlobPattern(String s) {
        return s.contains("*") || s.contains("{") || s.contains("}") || s.contains("[") || s.contains("]");
    }

    private static /* synthetic */ void lambda$addStaticFileIfPresent$0(Map staticFiles, String path, String resourceName, PathVisit pathVisit) {
        if (Files.isRegularFile(pathVisit.getPath(), new LinkOption[0])) {
            staticFiles.put(path, new StaticFile(resourceName, StaticFile.FetchType.CLASSPATH));
        }
    }
}

