/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.generator.runtime;

import io.quarkiverse.roq.generator.runtime.ConfiguredPathsProvider;
import io.quarkiverse.roq.generator.runtime.RoqGeneratorConfig;
import io.quarkiverse.roq.generator.runtime.RoqSelection;
import io.quarkiverse.roq.generator.runtime.SelectedPath;
import io.quarkiverse.roq.generator.runtime.StaticFile;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.arc.All;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Quarkus;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

@ApplicationScoped
public class RoqGenerator
implements Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(RoqGenerator.class);
    private final Instance<Vertx> vertx;
    private final RoqGeneratorConfig config;
    private final VertxHttpConfig httpConfiguration;
    private final VertxHttpBuildTimeConfig httpBuildTimeConfig;
    private final Map<String, StaticFile> staticFiles;
    private WebClient client;
    private final List<SelectedPath> selectedPaths;

    @Inject
    public RoqGenerator(Instance<Vertx> vertx, RoqGeneratorConfig config, VertxHttpConfig httpConfiguration, VertxHttpBuildTimeConfig httpBuildTimeConfig, @All List<RoqSelection> selection) {
        this.vertx = vertx;
        this.config = config;
        this.httpConfiguration = httpConfiguration;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
        this.staticFiles = ConfiguredPathsProvider.staticFiles();
        this.selectedPaths = RoqSelection.prepare(config, selection);
    }

    void onStart(@Observes Router router) {
        router.route("/roq/ping").method(HttpMethod.GET).handler(routingContext -> routingContext.response().end("pong"));
        if (this.config.batch()) {
            this.generate().subscribe().with(t -> {
                LOGGER.info((Object)("Roq generation succeeded in directory: " + this.outputDir()));
                Quarkus.asyncExit((int)0);
            }, throwable -> {
                if (throwable instanceof ConnectException) {
                    LOGGER.error((Object)"Roq generation failed");
                } else {
                    LOGGER.error((Object)"Roq generation failed", throwable);
                }
                Quarkus.asyncExit((int)1);
            });
        }
    }

    public String outputDir() {
        return PathUtils.toUnixPath((String)PathUtils.join((String)ConfiguredPathsProvider.targetDir(), (String)this.config.outputDir()));
    }

    private WebClient client() {
        if (this.client == null) {
            this.client = WebClient.create((Vertx)((Vertx)this.vertx.get()));
        }
        return this.client;
    }

    public void handle(RoutingContext event) {
        this.generate().subscribe().with(t -> {
            event.response().setStatusCode(200);
            event.response().end("Exported in: " + this.outputDir());
        }, arg_0 -> ((RoutingContext)event).fail(arg_0));
    }

    public Path generateBlocking() {
        return (Path)this.generate().await().atMost(Duration.ofSeconds(10L));
    }

    public Uni<Path> generate() {
        FileSystem fs = ((Vertx)this.vertx.get()).fileSystem();
        ArrayList<Uni> all = new ArrayList<Uni>();
        Path outputDir = Path.of(this.outputDir(), new String[0]).toAbsolutePath();
        for (SelectedPath path : this.selectedPaths) {
            all.add(this.fetchContent(path.path()).onFailure().retry().atMost((long)this.config.requestRetry()).chain(r -> {
                Path targetPath = outputDir.resolve(path.outputPath());
                return Uni.createFrom().completionStage(() -> fs.mkdirs(targetPath.getParent().toString()).toCompletionStage()).chain(() -> Uni.createFrom().completionStage(fs.writeFile(targetPath.toString(), r).toCompletionStage())).invoke(() -> LOGGER.infof("Roq generated file %s", (Object)path.outputPath()));
            }));
        }
        return RoqGenerator.clearOutputDir(fs, outputDir).chain(this::pollRoqPing).chain(() -> Uni.join().all(all).andFailFast().map(l -> outputDir)).ifNoItem().after(Duration.ofSeconds(this.config.timeout())).fail();
    }

    private static Uni<Void> clearOutputDir(FileSystem fs, Path outputDir) {
        return Uni.createFrom().completionStage(() -> fs.exists(outputDir.toString()).compose(r -> {
            if (r.booleanValue()) {
                return fs.deleteRecursive(outputDir.toString(), true);
            }
            return Future.succeededFuture();
        }).toCompletionStage());
    }

    private Uni<Void> pollRoqPing() {
        String pingPath = PathUtils.join((String)this.httpBuildTimeConfig.rootPath(), (String)"/roq/ping");
        return Multi.createFrom().ticks().every(Duration.ofMillis(500L)).onItem().transformToUniAndMerge(tick -> this.getSend(pingPath).map(r -> true).onFailure().recoverWithItem((Object)false)).filter(success -> success).toUni().replaceWithVoid().ifNoItem().after(Duration.ofSeconds(30L)).failWith(() -> new RuntimeException("Quarkus didn't start after 30 seconds (no response on '%s').".formatted(pingPath)));
    }

    private Uni<Buffer> fetchContent(String path) {
        if (this.staticFiles.containsKey(path)) {
            StaticFile staticFile = this.staticFiles.get(path);
            if (staticFile.type().equals((Object)StaticFile.FetchType.FILE)) {
                LOGGER.debugf("Roq is reading %s from file", (Object)path);
                return Uni.createFrom().completionStage(() -> ((Vertx)this.vertx.get()).fileSystem().readFile(staticFile.path()).onComplete(r -> LOGGER.debugf("Roq successfully read file %s", (Object)path)).toCompletionStage());
            }
            if (staticFile.type().equals((Object)StaticFile.FetchType.CLASSPATH)) {
                LOGGER.debugf("Roq is reading %s from classpath", (Object)path);
                return Uni.createFrom().completionStage(() -> ((Vertx)this.vertx.get()).executeBlocking(() -> this.getClasspathResourceContent(staticFile.path()), false).map(Buffer::buffer).onComplete(r -> LOGGER.debugf("Roq successfully read %s on classpath", (Object)path)).toCompletionStage());
            }
        }
        String fullPath = RoqGenerator.encode(PathUtils.join((String)this.httpBuildTimeConfig.rootPath(), (String)path));
        LOGGER.debugf("Roq is reading %s from http", (Object)fullPath);
        return this.getSend(fullPath).onFailure().invoke(t -> LOGGER.errorf(t, "Roq request failed %s", (Object)fullPath)).invoke(r -> LOGGER.debugf("Roq request completed %s", (Object)fullPath)).map(HttpResponse::bodyAsBuffer);
    }

    private Uni<HttpResponse<Buffer>> getSend(String path) {
        int port;
        String host;
        if (LaunchMode.current() == LaunchMode.TEST) {
            host = this.httpConfiguration.testHost().orElse(this.httpConfiguration.host());
            port = this.httpConfiguration.testPort();
        } else {
            host = this.httpConfiguration.host();
            port = this.httpConfiguration.port();
        }
        return Uni.createFrom().completionStage(() -> this.client().get(port, host, path).send().expecting((Expectation)HttpResponseExpectation.status((int)200)).toCompletionStage());
    }

    public static String encode(String p) {
        int queryIndex = p.indexOf(63);
        String path = queryIndex >= 0 ? p.substring(0, queryIndex) : p;
        String query = queryIndex >= 0 ? p.substring(queryIndex + 1) : null;
        try {
            URI uri = new URI(null, null, path, null);
            if (query != null) {
                return uri.toASCIIString() + "?" + query;
            }
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getClasspathResourceContent(String resourceName) {
        byte[] byArray;
        block9: {
            URL resource = this.getClassLoader().getResource(resourceName);
            if (resource == null) {
                LOGGER.warnf("The resource '%s' does not exist on classpath", (Object)resourceName);
                return null;
            }
            InputStream inputStream = resource.openStream();
            try {
                byArray = inputStream.readAllBytes();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error while reading file from Classpath for path " + resourceName), (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

