/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.generator.runtime;

import io.smallrye.config.WithDefault;

public interface PathReplaceConfig {
    public static final String DEFAULT_ALLOWED_REGEX = "[^a-zA-Z0-9_\\\\/.\\-]";
    public static final String DEFAULT_REPLACE_WITH = "-";

    @WithDefault(value="false")
    public boolean enabled();

    @WithDefault(value="[^a-zA-Z0-9_\\\\/.\\-]")
    public String allowedRegex();

    @WithDefault(value="-")
    public String replaceWith();

    public static PathReplaceConfig create(String allowedRegex, String replaceWith) {
        return new PathReplaceConfigImpl(true, allowedRegex, replaceWith);
    }

    public static PathReplaceConfig replaceConfig() {
        return new PathReplaceConfigImpl(true, DEFAULT_ALLOWED_REGEX, DEFAULT_REPLACE_WITH);
    }

    public static PathReplaceConfig createDefault() {
        return new PathReplaceConfigImpl(false, DEFAULT_ALLOWED_REGEX, DEFAULT_REPLACE_WITH);
    }

    public record PathReplaceConfigImpl(boolean enabled, String allowedRegex, String replaceWith) implements PathReplaceConfig
    {
    }
}

