/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.generator.runtime;

import io.quarkiverse.roq.generator.runtime.Origin;
import io.quarkiverse.roq.generator.runtime.PathReplaceConfig;
import io.quarkiverse.roq.util.PathUtils;
import java.util.regex.Pattern;

public record SelectedPath(String path, String outputPath, Origin source) {
    private SelectedPath(SelectedPathBuilder builder) {
        this(PathUtils.prefixWithSlash((String)builder.path), builder.outputPath, builder.source);
    }

    public SelectedPath clean(PathReplaceConfig config) {
        return new SelectedPath(this.path, SelectedPath.cleanOutputPath(config, this.outputPath), this.source);
    }

    public static SelectedPathBuilder builder() {
        return new SelectedPathBuilder();
    }

    public static String defaultOutputPath(String path) {
        if (path.endsWith("/")) {
            return path + "index.html";
        }
        return path;
    }

    static String cleanOutputPath(PathReplaceConfig options, String staticPath) {
        return options.enabled() ? Pattern.compile(options.allowedRegex()).matcher(staticPath).replaceAll(options.replaceWith()) : staticPath;
    }

    public static class SelectedPathBuilder {
        String path;
        Origin source = Origin.PROVIDED;
        String outputPath = null;

        public SelectedPathBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SelectedPathBuilder source(Origin source) {
            this.source = source;
            return this;
        }

        public SelectedPathBuilder html(String path) {
            this.path = path;
            this.outputPath = SelectedPath.defaultOutputPath(PathUtils.addTrailingSlash((String)path));
            return this;
        }

        public SelectedPathBuilder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public SelectedPath build() {
            if (this.outputPath == null || this.outputPath.isEmpty()) {
                this.outputPath = SelectedPath.defaultOutputPath(this.path);
            }
            if (this.outputPath.startsWith("/")) {
                this.outputPath = this.outputPath.substring(1);
            }
            return new SelectedPath(this);
        }
    }
}

