/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.aliases.deployment;

import io.quarkiverse.roq.frontmatter.deployment.TemplateLink;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterTemplateBuildItem;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqUrl;
import io.quarkiverse.roq.generator.deployment.items.SelectedPathBuildItem;
import io.quarkiverse.roq.plugin.aliases.deployment.items.RoqFrontMatterAliasesBuildItem;
import io.quarkiverse.roq.plugin.aliases.runtime.RoqFrontMatterAliasesRecorder;
import io.quarkiverse.roq.util.PathUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoqPluginAliasesProcessor {
    private static final String FEATURE = "roq-plugin-aliases";
    private static final Set<String> ALIASES_FOR_REDIRECTING = Set.of("redirect_from", "redirect-from", "aliases");

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void consumeTemplates(RoqSiteConfig config, List<RoqFrontMatterTemplateBuildItem> templates, BuildProducer<RoqFrontMatterAliasesBuildItem> aliasesProducer, BuildProducer<SelectedPathBuildItem> selectedPathsProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer) {
        if (templates.isEmpty()) {
            return;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (RoqFrontMatterTemplateBuildItem roqFrontMatterTemplateBuildItem : templates) {
            Set<String> aliasesName;
            if (!roqFrontMatterTemplateBuildItem.published() || (aliasesName = this.getAliases(roqFrontMatterTemplateBuildItem.data())).isEmpty()) continue;
            RoqUrl url = roqFrontMatterTemplateBuildItem.url();
            for (String alias : aliasesName) {
                String aliasLink = TemplateLink.pageLink((String)config.rootPath(), (String)alias, (TemplateLink.PageLinkData)new TemplateLink.PageLinkData(roqFrontMatterTemplateBuildItem.raw().info(), roqFrontMatterTemplateBuildItem.raw().collectionId(), roqFrontMatterTemplateBuildItem.data()));
                aliasMap.put(aliasLink, url.absolute());
            }
        }
        for (Map.Entry entry : aliasMap.entrySet()) {
            aliasesProducer.produce((BuildItem)new RoqFrontMatterAliasesBuildItem((String)entry.getKey(), (String)entry.getValue()));
            selectedPathsProducer.produce((BuildItem)new SelectedPathBuildItem(PathUtils.addTrailingSlash((String)((String)entry.getKey())), null));
            notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(PathUtils.prefixWithSlash((String)((String)entry.getKey())), "Roq URL alias for " + (String)entry.getValue() + " URL."));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void createVertxRedirects(RoqFrontMatterAliasesRecorder recorder, BuildProducer<RouteBuildItem> routes, List<RoqFrontMatterAliasesBuildItem> aliases) {
        for (RoqFrontMatterAliasesBuildItem item : aliases) {
            routes.produce((BuildItem)RouteBuildItem.builder().route(PathUtils.prefixWithSlash((String)item.alias())).handler(recorder.sendRedirectPage(item.target())).build());
        }
    }

    private Set<String> getAliases(JsonObject json) {
        HashSet<String> aliases = new HashSet<String>();
        for (String aliasesKey : ALIASES_FOR_REDIRECTING) {
            JsonArray jsonArray = json.getJsonArray(aliasesKey);
            if (jsonArray == null) continue;
            for (int i = 0; i < jsonArray.size(); ++i) {
                String alias = jsonArray.getString(i);
                if (alias.isBlank()) continue;
                aliases.add(alias);
            }
        }
        return aliases;
    }
}

