/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.asciidoc.common.deployment;

import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterHeaderParserBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterScanProcessor;
import io.quarkiverse.roq.frontmatter.deployment.scan.TemplateContext;
import io.vertx.core.json.JsonObject;
import io.yupiik.asciidoc.model.Header;
import io.yupiik.asciidoc.parser.Parser;
import io.yupiik.asciidoc.parser.internal.Reader;
import io.yupiik.asciidoc.parser.resolver.ContentResolver;
import io.yupiik.asciidoc.parser.resolver.RelativeContentResolver;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class AsciidocHeaderParser {
    private static final Logger LOGGER = Logger.getLogger(AsciidocHeaderParser.class);
    private static final ContentResolver EMPTY_CONTENT_RESOLVER = (ref, encoding) -> Optional.empty();
    private static final String QUTE_KEY = "qute";

    public static RoqFrontMatterHeaderParserBuildItem createBuildItem(boolean qute, Predicate<TemplateContext> isApplicable) {
        return new RoqFrontMatterHeaderParserBuildItem(isApplicable, templateContext -> {
            boolean escape;
            Parser parser = new Parser();
            String content = RoqFrontMatterScanProcessor.stripFrontMatter((String)templateContext.content());
            PathContentResolver contentResolver = new PathContentResolver(templateContext.sourceFile().getParent());
            Header header = parser.parseHeader(new Reader(content.lines().toList()), new Parser.ParserContext((ContentResolver)contentResolver));
            JsonObject pageData = AsciidocHeaderParser.toPageData(header);
            boolean bl = escape = !qute;
            if (header.attributes().containsKey(QUTE_KEY)) {
                String quteAttribute = (String)header.attributes().get(QUTE_KEY);
                boolean bl2 = escape = !quteAttribute.isEmpty() && !Boolean.parseBoolean(quteAttribute);
            }
            if (!pageData.containsKey("escape")) {
                pageData.put("escape", (Object)escape);
            }
            return pageData;
        }, Function.identity(), 20);
    }

    public static JsonObject toPageData(Header header) {
        JsonObject pageData = new JsonObject();
        Map<String, String> attributes = AsciidocHeaderParser.processAttributes(header.attributes());
        pageData.put("attributes", (Object)JsonObject.mapFrom(attributes));
        for (String key : attributes.keySet()) {
            if (!key.startsWith("page-")) continue;
            String value = attributes.get(key);
            pageData.put(key.substring(5), value.isEmpty() ? Boolean.valueOf(true) : value);
        }
        if (!header.title().isBlank()) {
            pageData.put("title", (Object)header.title());
        }
        if (header.attributes().containsKey("description") && !((String)header.attributes().get("description")).isBlank()) {
            pageData.put("description", header.attributes().get("description"));
        }
        if (!header.author().name().isBlank()) {
            pageData.put("author", (Object)new JsonObject().put("name", (Object)header.author().name()).put("email", (Object)header.author().mail()));
        }
        if (!header.revision().number().isBlank()) {
            pageData.put("revision", (Object)new JsonObject().put("number", (Object)header.revision().number()).put("date", (Object)header.revision().date()).put("remark", (Object)header.revision().revmark()));
        }
        if (attributes.containsKey("description")) {
            pageData.put("description", (Object)attributes.get("description"));
        }
        if (attributes.containsKey("image")) {
            pageData.put("image", (Object)attributes.get("image"));
        }
        return pageData;
    }

    public static Map<String, String> processAttributes(Map<String, String> input) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("!")) {
                result.remove(key.substring(1));
                continue;
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    static class PathContentResolver
    implements RelativeContentResolver {
        private final Path base;

        PathContentResolver(Path base) {
            this.base = base;
        }

        public Optional<RelativeContentResolver.Resolved> resolve(Path parent, String ref, Charset encoding) {
            Path rel = Path.of(ref, new String[0]);
            if (rel.isAbsolute()) {
                return PathContentResolver.doRead(rel, encoding);
            }
            if (parent != null && parent.getParent() != null) {
                return PathContentResolver.doRead(parent.getParent().resolve(ref), encoding);
            }
            Path resolved = this.base.resolve(ref);
            return PathContentResolver.doRead(resolved, encoding);
        }

        private static Optional<RelativeContentResolver.Resolved> doRead(Path resolved, Charset encoding) {
            if (Files.isRegularFile(resolved, new LinkOption[0])) {
                try {
                    return Optional.of(new RelativeContentResolver.Resolved(resolved, Files.readAllLines(resolved, encoding)));
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't read '" + String.valueOf(resolved) + "'");
                }
            }
            LOGGER.warnf("Include file '%s' not found", (Object)resolved);
            return Optional.of(new RelativeContentResolver.Resolved(null, List.of()));
        }
    }
}

