/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.asciidoctorj.runtime;

import io.quarkiverse.roq.plugin.asciidoctorj.runtime.AsciidoctorJConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.jboss.logging.Logger;

@Singleton
public class AsciidoctorJConverter {
    private static final Logger LOG = Logger.getLogger(AsciidoctorJConverter.class);
    private final Asciidoctor asciidoctor;
    private final AsciidoctorJConfig config;
    private final Options options;

    @Inject
    public AsciidoctorJConverter(AsciidoctorJConfig config) {
        LOG.info((Object)"Starting Asciidoctorj...");
        Instant start = Instant.now();
        this.asciidoctor = Asciidoctor.Factory.create();
        this.config = config;
        this.asciidoctor.requireLibrary(new String[]{"asciidoctor-diagram"});
        AttributesBuilder attributes = Attributes.builder().showTitle(true).attribute("noheader", (Object)true);
        config.attributes().forEach((arg_0, arg_1) -> ((AttributesBuilder)attributes).attribute(arg_0, arg_1));
        Path templateDir = Paths.get(config.templatesDir(), new String[0]);
        OptionsBuilder optionsBuilder = Options.builder();
        if (Files.isDirectory(templateDir, new LinkOption[0])) {
            optionsBuilder.templateDirs(new File[]{templateDir.toAbsolutePath().toFile()});
            optionsBuilder.standalone(true);
        } else {
            optionsBuilder.standalone(false);
        }
        Path workingDir = Paths.get("", new String[0]);
        if (Files.isDirectory(workingDir, new LinkOption[0])) {
            optionsBuilder.baseDir(workingDir.toAbsolutePath().toFile());
        }
        this.options = optionsBuilder.safe(SafeMode.SAFE).backend("html5").attributes(attributes.build()).build();
        LOG.infof("Asciidoctorj started in %sms", (Object)Duration.between(start, Instant.now()).toMillis());
    }

    public String apply(String asciidoc) {
        return this.asciidoctor.convert(AsciidoctorJConverter.trimIndent(asciidoc), this.options);
    }

    public static String trimIndent(String content) {
        String[] lines;
        int minIndent = Integer.MAX_VALUE;
        boolean foundNonEmptyLine = false;
        for (String line : lines = content.split("\\v")) {
            if (line.trim().isEmpty()) continue;
            int leadingSpaces = line.indexOf(line.trim());
            minIndent = Math.min(minIndent, leadingSpaces);
            foundNonEmptyLine = true;
        }
        if (!foundNonEmptyLine || minIndent == 0) {
            return content;
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (line.length() >= minIndent) {
                result.append(line.substring(minIndent));
            } else {
                result.append(line);
            }
            result.append("\n");
        }
        return result.toString();
    }
}

