/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.asciidoctorj.runtime;

import io.quarkiverse.roq.plugin.asciidoctorj.runtime.AsciidoctorJConverter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EngineConfiguration;
import io.quarkus.qute.RawString;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SingleResultNode;
import io.quarkus.qute.TemplateExtension;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.CompletionStage;

@EngineConfiguration
public class AsciidoctorJSectionHelperFactory
implements SectionHelperFactory<AsciidocSectionHelper> {
    private static final LazyValue<AsciidoctorJConverter> CONVERTER = new LazyValue(() -> (AsciidoctorJConverter)Arc.container().instance(AsciidoctorJConverter.class, new Annotation[0]).get());
    private final AsciidoctorJConverter converter;

    public AsciidoctorJSectionHelperFactory() {
        this.converter = null;
    }

    @Inject
    public AsciidoctorJSectionHelperFactory(AsciidoctorJConverter converter) {
        this.converter = converter;
    }

    public List<String> getDefaultAliases() {
        return List.of("asciidoc", "ascii");
    }

    public AsciidocSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
        return new AsciidocSectionHelper(this.converter);
    }

    @TemplateExtension(matchNames={"asciidocify", "asciidocToHtml"})
    static RawString convertToAsciidoc(String text, String ignoredName) {
        return new RawString(((AsciidoctorJConverter)CONVERTER.get()).apply(text));
    }

    public static class AsciidocSectionHelper
    implements SectionHelper {
        private final AsciidoctorJConverter converter;

        public AsciidocSectionHelper(AsciidoctorJConverter converter) {
            this.converter = converter;
        }

        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return context.execute().thenCompose(rn -> {
                StringBuilder sb = new StringBuilder();
                rn.process(sb::append);
                return CompletedStage.of((Object)new SingleResultNode((Object)this.converter.apply(sb.toString())));
            });
        }
    }
}

