/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.asciidoctorj.runtime;

import io.quarkiverse.roq.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;

public class AsciidocJInclude
extends IncludeProcessor {
    private static final Pattern URL_PREFIX_PATTERN = Pattern.compile("^((https?|file|ftp|irc)://|mailto:)");
    private static final Pattern HEADING_PATTERN = Pattern.compile("^(=+)(\\s+.*)$");

    public boolean handles(String target) {
        return !URL_PREFIX_PATTERN.matcher(target).matches() && (target.endsWith(".adoc") || target.endsWith(".asciidoc"));
    }

    public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
        Path targetPath;
        long safeLevel = (Long)document.getOptions().get("safe");
        if (safeLevel >= (long)SafeMode.SECURE.getLevel()) {
            throw new SecurityException("File includes are not allowed in SECURE mode.");
        }
        String dir = reader.getDir();
        Charset charset = Charset.forName(document.getAttributes().getOrDefault("encoding", "UTF-8"));
        Path baseDir = Path.of(document.getOptions().getOrDefault("base_dir", "").toString(), new String[0]);
        Path p = Path.of(target, new String[0]);
        Path path = targetPath = p.isAbsolute() ? p : baseDir.resolve(dir).resolve(target).normalize();
        if (safeLevel >= (long)SafeMode.SAFE.getLevel() && !targetPath.startsWith(baseDir.normalize())) {
            throw new SecurityException("Include path is outside baseDir in SAFE or higher mode: " + String.valueOf(targetPath));
        }
        String resourcePath = PathUtils.toUnixPath((String)targetPath.toString());
        try (InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
            if (resource != null) {
                AsciidocJInclude.pushInclude(reader, new String(resource.readAllBytes(), charset), target, attributes);
                return;
            }
        }
        catch (IOException e) {
            this.log(new LogRecord(Severity.ERROR, "Can't read '" + target + "'"));
            return;
        }
        if (!Files.isRegularFile(targetPath, new LinkOption[0])) {
            this.log(new LogRecord(Severity.ERROR, "Include file not found '" + target + "'"));
            return;
        }
        try {
            AsciidocJInclude.pushInclude(reader, Files.readString(targetPath, charset), target, attributes);
        }
        catch (IOException e) {
            this.log(new LogRecord(Severity.ERROR, "Can't read '" + target + "'"));
        }
    }

    private static void pushInclude(PreprocessorReader reader, String content, String target, Map<String, Object> attributes) throws IOException {
        String processedContent = String.join((CharSequence)"\n", AsciidocJInclude.processInclude(content, attributes));
        reader.pushInclude(processedContent, target, target, 1, attributes);
    }

    static List<String> processInclude(String content, Map<String, Object> attrs) throws IOException {
        List<String> lines = content.lines().toList();
        if (attrs.containsKey("tag") && attrs.get("tag") instanceof String) {
            lines = AsciidocJInclude.extractTag(lines, (String)attrs.get("tag"));
        } else if (attrs.containsKey("tags") && attrs.get("tags") instanceof String) {
            String tags = (String)attrs.get("tags");
            for (String tag : tags.split(",")) {
                lines = AsciidocJInclude.extractTag(lines, tag.trim());
            }
        }
        if (attrs.containsKey("lines") && attrs.get("lines") instanceof String) {
            lines = AsciidocJInclude.extractLines(lines, (String)attrs.get("lines"));
        }
        if (attrs.containsKey("indent") && attrs.get("indent") instanceof String) {
            int indent = Integer.parseInt((String)attrs.get("indent"));
            String pad = " ".repeat(indent);
            lines = lines.stream().map(line -> pad + line).toList();
        }
        return lines;
    }

    private static List<String> extractTag(List<String> lines, String tag) {
        Pattern start = Pattern.compile("^//\\s*tag::" + Pattern.quote(tag) + "\\[\\]");
        Pattern end = Pattern.compile("^//\\s*end::" + Pattern.quote(tag) + "\\[\\]");
        ArrayList<String> result = new ArrayList<String>();
        boolean inTag = false;
        for (String line : lines) {
            if (!inTag && start.matcher(line).find()) {
                inTag = true;
                continue;
            }
            if (inTag && end.matcher(line).find()) break;
            if (!inTag) continue;
            result.add(line);
        }
        return result;
    }

    private static List<String> extractLines(List<String> lines, String lineRanges) {
        LinkedHashSet<Integer> indices = new LinkedHashSet<Integer>();
        for (String part : lineRanges.split("[;,]")) {
            if ((part = part.trim()).matches("\\d+")) {
                indices.add(Integer.parseInt(part) - 1);
                continue;
            }
            if (!part.matches("\\d+\\.\\.\\d+")) continue;
            String[] range = part.split("\\.\\.");
            int start = Integer.parseInt(range[0]) - 1;
            int end = Integer.parseInt(range[1]) - 1;
            for (int i = start; i <= end; ++i) {
                indices.add(i);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            if (idx < 0 || idx >= lines.size()) continue;
            result.add(lines.get(idx));
        }
        return result;
    }

    private static List<String> applyLevelOffset(List<String> lines, String leveloffset) {
        int offset = 0;
        offset = leveloffset.startsWith("+") || leveloffset.startsWith("-") ? Integer.parseInt(leveloffset) : Integer.parseInt(leveloffset);
        ArrayList<String> result = new ArrayList<String>();
        Pattern heading = HEADING_PATTERN;
        for (String line : lines) {
            Matcher m = heading.matcher(line);
            if (m.matches()) {
                int level = m.group(1).length() + offset;
                level = Math.max(1, level);
                String newLine = "=".repeat(level) + m.group(2);
                result.add(newLine);
                continue;
            }
            result.add(line);
        }
        return result;
    }
}

