/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.asciidoctorj.runtime;

import io.quarkiverse.roq.frontmatter.runtime.RoqTemplateAttributes;
import io.quarkiverse.roq.plugin.asciidoc.common.runtime.AsciidocTemplateExtension;
import io.quarkiverse.roq.plugin.asciidoctorj.runtime.AsciidoctorJConverter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EngineConfiguration;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.RawString;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SingleResultNode;
import io.quarkus.qute.TemplateExtension;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

@EngineConfiguration
public class AsciidoctorJSectionHelperFactory
implements SectionHelperFactory<AsciidocSectionHelper> {
    private static final LazyValue<AsciidoctorJConverter> CONVERTER = new LazyValue(() -> (AsciidoctorJConverter)Arc.container().instance(AsciidoctorJConverter.class, new Annotation[0]).get());
    private static final String ASCIIDOC_ATTRIBUTES = "attributes";
    private final AsciidoctorJConverter converter;

    public AsciidoctorJSectionHelperFactory() {
        this.converter = null;
    }

    @Inject
    public AsciidoctorJSectionHelperFactory(AsciidoctorJConverter converter) {
        this.converter = converter;
    }

    public List<String> getDefaultAliases() {
        return List.of("asciidoc", "ascii");
    }

    public SectionHelperFactory.ParametersInfo getParameters() {
        return SectionHelperFactory.ParametersInfo.builder().addParameter(Parameter.builder((String)ASCIIDOC_ATTRIBUTES).optional().build()).checkNumberOfParams(false).build();
    }

    public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
        if (block.hasParameter(ASCIIDOC_ATTRIBUTES)) {
            block.addExpression(ASCIIDOC_ATTRIBUTES, block.getParameter(ASCIIDOC_ATTRIBUTES));
        }
        return outerScope;
    }

    public AsciidocSectionHelper initialize(SectionHelperFactory.SectionInitContext c) {
        Expression asciidocAttributesExpr = c.getExpression(ASCIIDOC_ATTRIBUTES);
        return new AsciidocSectionHelper(asciidocAttributesExpr);
    }

    @TemplateExtension(matchNames={"asciidocify", "asciidocToHtml"})
    static RawString convertToAsciidoc(String text, String ignoredName, @TemplateExtension.TemplateAttribute(value="sourcePath") Object templatePath, @TemplateExtension.TemplateAttribute(value="sitePath") Object sitePath, @TemplateExtension.TemplateAttribute(value="siteUrl") Object siteUrl, @TemplateExtension.TemplateAttribute(value="pagePath") Object pagePath, @TemplateExtension.TemplateAttribute(value="pageUrl") Object pageUrl) {
        return AsciidoctorJSectionHelperFactory.convertToAsciidoc(text, ignoredName, Map.of(), templatePath, sitePath, siteUrl, pagePath, pageUrl);
    }

    @TemplateExtension(matchNames={"asciidocify", "asciidocToHtml"})
    static RawString convertToAsciidoc(String text, String ignoredName, Map<String, Object> attributes, @TemplateExtension.TemplateAttribute(value="sourcePath") Object templatePath, @TemplateExtension.TemplateAttribute(value="sitePath") Object sitePath, @TemplateExtension.TemplateAttribute(value="siteUrl") Object siteUrl, @TemplateExtension.TemplateAttribute(value="pagePath") Object pagePath, @TemplateExtension.TemplateAttribute(value="pageUrl") Object pageUrl) {
        return new RawString(((AsciidoctorJConverter)CONVERTER.get()).apply(text, AsciidocTemplateExtension.convertToStringMap(attributes), new RoqTemplateAttributes((String)templatePath, (String)siteUrl, (String)sitePath, (String)pageUrl, (String)pagePath)));
    }

    class AsciidocSectionHelper
    implements SectionHelper {
        private final Expression asciidocAttributesExpr;

        public AsciidocSectionHelper(Expression asciidocAttributesExpr) {
            this.asciidocAttributesExpr = asciidocAttributesExpr;
        }

        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            if (this.asciidocAttributesExpr != null) {
                return context.evaluate(this.asciidocAttributesExpr).thenCompose(a -> this.execute(a, context));
            }
            return this.execute(null, context);
        }

        private CompletionStage<ResultNode> execute(Object a, SectionHelper.SectionResolutionContext context) {
            return context.execute().thenCompose(rn -> {
                Map asciidocAttributes = Map.of();
                if (a instanceof Map) {
                    asciidocAttributes = AsciidocTemplateExtension.convertToStringMap((Map)((Map)a));
                }
                StringBuilder sb = new StringBuilder();
                rn.process(sb::append);
                ResolutionContext resolutionContext = context.resolutionContext();
                RoqTemplateAttributes attributes = new RoqTemplateAttributes((String)resolutionContext.getAttribute("sourcePath"), (String)resolutionContext.getAttribute("siteUrl"), (String)resolutionContext.getAttribute("sitePath"), (String)resolutionContext.getAttribute("pageUrl"), (String)resolutionContext.getAttribute("pagePath"));
                return CompletedStage.of((Object)new SingleResultNode((Object)AsciidoctorJSectionHelperFactory.this.converter.apply(sb.toString(), asciidocAttributes, attributes)));
            });
        }
    }
}

