/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.asciidoctorj.runtime;

import io.quarkiverse.roq.frontmatter.runtime.RoqTemplateAttributes;
import io.quarkiverse.roq.plugin.asciidoctorj.runtime.AsciidocJInclude;
import io.quarkiverse.roq.plugin.asciidoctorj.runtime.AsciidoctorJConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.jboss.logging.Logger;

@Singleton
public class AsciidoctorJConverter {
    private static final Logger LOG = Logger.getLogger(AsciidoctorJConverter.class);
    public static final String ROOTDIR = "root_dir";
    private final Asciidoctor asciidoctor;
    private Map<String, String> configuredAttributes;

    @Inject
    public AsciidoctorJConverter(AsciidoctorJConfig config) {
        this(config.attributes());
    }

    public AsciidoctorJConverter(Map<String, String> configuredAttributes) {
        this.configuredAttributes = configuredAttributes;
        LOG.info((Object)"Starting Asciidoctorj...");
        Instant start = Instant.now();
        this.asciidoctor = Asciidoctor.Factory.create();
        this.asciidoctor.requireLibrary(new String[]{"asciidoctor-diagram"});
        this.asciidoctor.javaExtensionRegistry().includeProcessor((IncludeProcessor)new AsciidocJInclude());
        LOG.infof("Asciidoctorj started in %sms", (Object)Duration.between(start, Instant.now()).toMillis());
    }

    public Options createOptions(Map<String, String> asciidocAttributes, RoqTemplateAttributes templateAttributes) {
        AttributesBuilder attributes = Attributes.builder().showTitle(true).attribute("sitegen", (Object)"roq").attribute("relfileprefix", (Object)"../").attribute("relfilesuffix", (Object)"/").attribute("noheader", (Object)true);
        if (templateAttributes.pageUrl() != null) {
            attributes.attribute("page-url", (Object)templateAttributes.pageUrl());
        }
        if (templateAttributes.pagePath() != null) {
            attributes.attribute("page-path", (Object)templateAttributes.pagePath());
        }
        if (templateAttributes.siteUrl() != null) {
            attributes.attribute("site-url", (Object)templateAttributes.siteUrl());
        }
        if (templateAttributes.sitePath() != null) {
            attributes.attribute("site-path", (Object)templateAttributes.sitePath());
        }
        this.configuredAttributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributes).attribute(arg_0, arg_1));
        asciidocAttributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributes).attribute(arg_0, arg_1));
        OptionsBuilder optionsBuilder = Options.builder();
        if (templateAttributes.sourcePath() != null) {
            Path templateDir = Paths.get(templateAttributes.sourcePath(), new String[0]).getParent();
            optionsBuilder.option("base_dir", (Object)templateDir.toAbsolutePath().toString());
            optionsBuilder.option(ROOTDIR, (Object)templateAttributes.sourceRootPath());
        }
        return optionsBuilder.safe(SafeMode.SAFE).backend("html5").attributes(attributes.build()).build();
    }

    public String apply(String asciidoc, Map<String, String> asciidocAttributes, RoqTemplateAttributes templateAttributes) {
        Options options = this.createOptions(asciidocAttributes, templateAttributes);
        Document doc = this.asciidoctor.load(AsciidoctorJConverter.trimIndent(asciidoc), options);
        return doc.convert();
    }

    public static String trimIndent(String content) {
        String[] lines;
        int minIndent = Integer.MAX_VALUE;
        boolean foundNonEmptyLine = false;
        for (String line : lines = content.split("\\v")) {
            if (line.trim().isEmpty()) continue;
            int leadingSpaces = line.indexOf(line.trim());
            minIndent = Math.min(minIndent, leadingSpaces);
            foundNonEmptyLine = true;
        }
        if (!foundNonEmptyLine || minIndent == 0) {
            return content;
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (line.length() >= minIndent) {
                result.append(line.substring(minIndent));
            } else {
                result.append(line);
            }
            result.append("\n");
        }
        return result.toString();
    }
}

