/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.lunr.runtime;

import io.quarkiverse.roq.frontmatter.runtime.RoqTemplateExtension;
import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.NormalPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkus.arc.Unremovable;
import io.quarkus.qute.RawString;
import io.quarkus.qute.TemplateExtension;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@TemplateExtension
@Unremovable
public class RoqPluginLunrTemplateExtension {
    public static final String INDEX_BOOST_KEY = "search-boost";

    public static boolean search(Page page) {
        return page.source().isTargetHtml() && page.data().getBoolean("search", Boolean.valueOf(true)) != false;
    }

    public static RawString searchIndex(Site site) {
        JsonObject json = new JsonObject();
        for (RoqCollection collection : site.collections().list()) {
            if (collection.hidden() || collection.derived()) continue;
            for (DocumentPage doc : collection) {
                if (!RoqPluginLunrTemplateExtension.search((Page)doc)) continue;
                RoqPluginLunrTemplateExtension.createPageJsonObjects(site, (Page)doc).forEach((arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1));
            }
        }
        for (NormalPage page : site.pages()) {
            if (!RoqPluginLunrTemplateExtension.search((Page)page)) continue;
            RoqPluginLunrTemplateExtension.createPageJsonObjects(site, (Page)page).forEach((arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1));
        }
        return new RawString(json.toString());
    }

    private static Map<String, JsonObject> createPageJsonObjects(Site site, Page page) {
        HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
        String html = site.pageContent(page);
        Document htmlDoc = Jsoup.parse((String)html);
        List<Anchor> anchors = RoqPluginLunrTemplateExtension.extractAnchors(htmlDoc);
        JsonObject baseDoc = new JsonObject().put("summary", (Object)page.description());
        if (page.data().containsKey("tags")) {
            List tags = RoqTemplateExtension.asStrings((Object)page.data("tags"));
            baseDoc.put("tags", (Object)tags);
        }
        long baseBoost = page.data().containsKey(INDEX_BOOST_KEY) ? page.data().getLong(INDEX_BOOST_KEY) : 1L;
        String absoluteUrl = page.url().absolute();
        if (!anchors.isEmpty()) {
            for (Anchor a : anchors) {
                if (a.content().isBlank()) continue;
                JsonObject d = baseDoc.copy().put("content", (Object)a.content()).put("title", (Object)(page.title() + " - " + a.title())).put("url", (Object)(absoluteUrl + "#" + a.id())).put("fragment", (Object)a.id()).put("boost", (Object)(baseBoost + (long)a.boost()));
                map.put(page.id() + "#" + a.id(), d);
            }
        }
        baseDoc.put("url", (Object)absoluteUrl).put("title", (Object)page.title()).put("content", (Object)htmlDoc.text()).put("boost", (Object)baseBoost);
        map.put(page.id(), baseDoc);
        return map;
    }

    static List<Anchor> extractAnchors(Document html) {
        return Stream.concat(RoqPluginLunrTemplateExtension.extractAsciidocAnchors(html).stream(), RoqPluginLunrTemplateExtension.extractMarkdownAnchors(html).stream()).toList();
    }

    private static List<Anchor> extractAsciidocAnchors(Document html) {
        ArrayList<Anchor> anchors = new ArrayList<Anchor>();
        for (Element section : html.select("div.sect1, div.sect2, div.sect3, div.sect4, div.sect5, div.sect6")) {
            String content;
            String id;
            Element heading = section.selectFirst("h1, h2, h3, h4, h5, h6");
            if (heading == null) continue;
            if (heading.hasAttr("id")) {
                id = heading.attr("id");
            } else {
                if (!section.hasAttr("id")) continue;
                id = section.attr("id");
            }
            String title = heading.text();
            Element contentClone = section.clone();
            Element headingClone = contentClone.selectFirst(heading.tagName() + "#" + id);
            if (headingClone != null) {
                headingClone.remove();
            }
            if ((content = contentClone.text()).isBlank()) continue;
            int boost = RoqPluginLunrTemplateExtension.boostForTag(heading.tagName());
            anchors.add(new Anchor(id, title, content, boost));
        }
        return anchors;
    }

    public static List<Anchor> extractMarkdownAnchors(Document doc) {
        ArrayList<Anchor> anchors = new ArrayList<Anchor>();
        Elements headings = doc.select("h1[id], h2[id], h3[id], h4[id], h5[id], h6[id]");
        for (Element heading : headings) {
            if (heading.parents().stream().anyMatch(p -> p.classNames().stream().anyMatch(c -> c.startsWith("sect")))) continue;
            String id = heading.id();
            String title = heading.text();
            int level = Integer.parseInt(heading.tagName().substring(1));
            int boost = level + 1;
            StringBuilder contentBuilder = new StringBuilder();
            for (Element current = heading.nextElementSibling(); current != null && !current.tagName().matches("h[1-" + level + "]"); current = current.nextElementSibling()) {
                contentBuilder.append(current.text()).append(" ");
            }
            String content = contentBuilder.toString().trim();
            if (content.isBlank()) continue;
            anchors.add(new Anchor(id, title, content, boost));
        }
        return anchors;
    }

    private static int boostForTag(String tagName) {
        if (tagName.matches("h[1-6]")) {
            return Integer.parseInt(tagName.substring(1)) + 1;
        }
        return 1;
    }

    record Anchor(String id, String title, String content, int boost) {
    }
}

