/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.series.deployment;

import io.quarkiverse.roq.frontmatter.deployment.RoqFrontMatterOutputBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterDocumentBuildItem;
import io.quarkiverse.roq.plugin.series.runtime.Series;
import io.quarkiverse.roq.plugin.series.runtime.SeriesMessage;
import io.quarkiverse.roq.plugin.series.runtime.SeriesRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RoqPluginSeriesProcessor {
    private static final String FEATURE = "roq-plugin-series";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerAdditionalBeans(RoqFrontMatterOutputBuildItem roqOutput, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (roqOutput == null) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{SeriesMessage.class}).setUnremovable().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Series.class}).serialization().constructors().fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Series.SeriesEntry.class}).serialization().constructors().fields().methods().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void generateSeries(SeriesRecorder recorder, BuildProducer<SyntheticBeanBuildItem> beansProducer, List<RoqFrontMatterDocumentBuildItem> documents) {
        Map<String, List> series = documents.stream().filter(item -> item.data().containsKey("series")).collect(Collectors.toMap(item -> item.data().getString("series"), item -> new ArrayList<String>(List.of(item.template().source().id())), (a, b) -> {
            a.addAll(b);
            return a;
        }));
        if (series.isEmpty()) {
            return;
        }
        beansProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Series.class).named("series")).scope(Singleton.class)).unremovable()).runtimeValue(recorder.generateSeries(series)).done());
    }
}

