/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.series.runtime;

import io.quarkiverse.roq.frontmatter.runtime.model.DocumentPage;
import io.quarkiverse.roq.frontmatter.runtime.model.Page;
import io.quarkiverse.roq.frontmatter.runtime.model.RoqCollection;
import io.quarkiverse.roq.frontmatter.runtime.model.Site;
import io.quarkiverse.roq.frontmatter.runtime.utils.Sites;
import io.quarkus.arc.impl.LazyValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record Series(Map<String, SeriesEntry> series) {
    public static final String FM_SERIE = "series";

    public SeriesEntry get(Page page) {
        if (!page.data().containsKey(FM_SERIE)) {
            return null;
        }
        return this.series.get(page.data().getString(FM_SERIE));
    }

    public static final class SeriesEntry {
        private final String title;
        private final List<String> documentIds;
        private final LazyValue<List<DocumentPage>> documents;

        public SeriesEntry(String title, List<String> documentIds) {
            this.title = title;
            this.documentIds = documentIds;
            this.documents = new LazyValue(() -> {
                Site site = Sites.getSite();
                return documentIds.stream().map(arg_0 -> ((Site)site).document(arg_0)).sorted(RoqCollection.BY_DATE.reversed()).toList();
            });
        }

        public List<DocumentPage> documents() {
            return (List)this.documents.get();
        }

        public String title() {
            return this.title;
        }

        public List<String> documentIds() {
            return this.documentIds;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SeriesEntry that = (SeriesEntry)obj;
            return Objects.equals(this.title, that.title) && Objects.equals(this.documentIds, that.documentIds);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.documentIds);
        }

        public String toString() {
            return "series[title=" + this.title + ", documentIds=" + String.valueOf(this.documentIds) + "]";
        }
    }
}

