/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.plugin.sitemap.deployment;

import io.quarkiverse.roq.frontmatter.deployment.data.RoqFrontMatterDataModificationBuildItem;
import io.quarkiverse.roq.frontmatter.deployment.exception.RoqPluginException;
import io.quarkiverse.roq.frontmatter.deployment.scan.RoqFrontMatterScanProcessor;
import io.quarkiverse.roq.frontmatter.runtime.config.RoqSiteConfig;
import io.quarkiverse.roq.plugin.sitemap.runtime.RoqPluginSitemapTemplateExtension;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jboss.logging.Logger;

public class RoqPluginSitemapProcessor {
    private static final Logger LOGGER = Logger.getLogger(RoqFrontMatterScanProcessor.class);
    private static final String FEATURE = "roq-plugin-sitemap";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem process() {
        return new AdditionalBeanBuildItem(new Class[]{RoqPluginSitemapTemplateExtension.class});
    }

    @BuildStep
    RoqFrontMatterDataModificationBuildItem addLastModifiedData(RoqSiteConfig config, LaunchModeBuildItem launchMode) {
        return new RoqFrontMatterDataModificationBuildItem(source -> {
            JsonObject fm;
            block10: {
                fm = source.fm();
                if (!fm.containsKey("last-modified-at")) {
                    try {
                        FileRepositoryBuilder builder = new FileRepositoryBuilder();
                        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).findGitDir()).build();
                        Path repoDir = repository.getDirectory().toPath().getParent();
                        if (!source.path().startsWith(repoDir)) break block10;
                        try (Git git = new Git(repository);){
                            Iterable logs = git.log().addPath(repoDir.relativize(source.path()).toString()).call();
                            RevCommit latestCommit = (RevCommit)logs.iterator().next();
                            if (latestCommit != null) {
                                ZonedDateTime lastModifiedDate = ZonedDateTime.ofInstant(Instant.ofEpochSecond(latestCommit.getCommitTime()), config.timeZone().isPresent() ? ZoneId.of((String)config.timeZone().get()) : ZoneId.systemDefault());
                                String lastModifiedString = lastModifiedDate.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
                                fm.put("last-modified-at", (Object)lastModifiedString);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
                            LOGGER.warnf((Throwable)e, "Error while reading git last commit date for file: %s", (Object)source.path());
                        }
                        throw new RoqPluginException("Error while reading git last commit date for file: %s".formatted(source.path()), (Throwable)e);
                    }
                }
            }
            return fm;
        });
    }
}

