/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.roq.testing;

import io.quarkiverse.roq.generator.runtime.RoqGenerator;
import io.quarkiverse.roq.testing.RoqAndRoll;
import io.quarkus.arc.Arc;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.junit.callback.QuarkusTestAfterAllCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeTestExecutionCallback;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;

public class RoqGeneratorTestCallback
implements QuarkusTestAfterConstructCallback,
QuarkusTestAfterAllCallback,
QuarkusTestBeforeTestExecutionCallback {
    private static final RoqAndRollManager INSTANCE = new RoqAndRollManager();

    public void afterConstruct(Object testInstance) {
        INSTANCE.afterConstruct(testInstance);
    }

    public void beforeTestExecution(QuarkusTestMethodContext context) {
        INSTANCE.beforeTestExecution(context);
    }

    public void afterAll(QuarkusTestContext context) {
        INSTANCE.afterAll(context);
    }

    private static class RoqAndRollManager
    implements QuarkusTestAfterConstructCallback,
    QuarkusTestAfterAllCallback,
    QuarkusTestBeforeTestExecutionCallback {
        private StaticHandler staticHandler;
        private RoqAndRoll options;
        private HttpServer httpServer;
        private final AtomicBoolean started = new AtomicBoolean(false);
        private static final RoqGeneratorTestCallback INSTANCE = new RoqGeneratorTestCallback();

        private RoqAndRollManager() {
        }

        public void afterConstruct(Object testInstance) {
            RoqAndRoll annotation = testInstance.getClass().getAnnotation(RoqAndRoll.class);
            if (annotation != null) {
                this.options = annotation;
                if (this.started.compareAndSet(false, true)) {
                    RoqGenerator roqGenerator = (RoqGenerator)Arc.container().instance(RoqGenerator.class, new Annotation[0]).get();
                    Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
                    Path outputDir = roqGenerator.generateBlocking();
                    this.staticHandler = StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)outputDir.toAbsolutePath().toString());
                    Router router = Router.router((Vertx)vertx);
                    router.route("/*").handler((Handler)this.staticHandler);
                    this.httpServer = vertx.createHttpServer(new HttpServerOptions().setPort(this.options.port()));
                    this.httpServer.requestHandler((Handler)router).listen(result -> {
                        if (result.failed()) {
                            throw new RuntimeException("Failed to start Roq test static server", result.cause());
                        }
                    });
                }
            }
        }

        public void beforeTestExecution(QuarkusTestMethodContext context) {
            if (this.options != null) {
                RestAssuredURLManager.setURL((boolean)false, (Integer)this.options.port());
            }
        }

        public void afterAll(QuarkusTestContext context) {
            if (this.httpServer != null) {
                this.options = null;
                this.started.set(false);
                this.httpServer.close(result -> {
                    if (result.failed()) {
                        System.err.println("Failed to stop Roq test static server: " + result.cause().getMessage());
                    }
                });
            }
        }
    }
}

