/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tika;

import io.quarkus.tika.TikaContent;
import io.quarkus.tika.TikaMetadata;
import io.quarkus.tika.TikaParseException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.AbstractRecursiveParserWrapperHandler;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TikaParser {
    private Parser parser;
    private boolean appendEmbeddedContent;

    public TikaParser(Parser parser, boolean appendEmbeddedContent) {
        this.parser = parser;
        this.appendEmbeddedContent = appendEmbeddedContent;
    }

    public TikaContent parse(InputStream stream) throws TikaParseException {
        return this.parse(stream, (String)null);
    }

    public TikaContent parse(InputStream stream, ContentHandler contentHandler) throws TikaParseException {
        return this.parse(stream, null, this.validateContentHandler(contentHandler));
    }

    public TikaContent parse(InputStream stream, String contentType) throws TikaParseException {
        return this.parse(stream, contentType, this.createContentHandler());
    }

    public TikaContent parse(InputStream stream, String contentType, ContentHandler contentHandler) throws TikaParseException {
        return this.parseStream(stream, contentType, this.validateContentHandler(contentHandler));
    }

    public String getText(InputStream stream) throws TikaParseException {
        return this.parse(stream).getText();
    }

    public String getText(InputStream stream, ContentHandler contentHandler) throws TikaParseException {
        return this.parse(stream, this.validateContentHandler(contentHandler)).getText();
    }

    public String getText(InputStream stream, String contentType) throws TikaParseException {
        return this.parse(stream, contentType).getText();
    }

    public String getText(InputStream stream, String contentType, ContentHandler contentHandler) throws TikaParseException {
        return this.parse(stream, contentType, this.validateContentHandler(contentHandler)).getText();
    }

    public TikaMetadata getMetadata(InputStream stream) throws TikaParseException {
        return this.getMetadata(stream, null);
    }

    public TikaMetadata getMetadata(InputStream stream, String contentType) throws TikaParseException {
        return this.parseStream(stream, contentType, this.createContentHandlerForMetadataOnly(contentType)).getMetadata();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TikaContent parseStream(InputStream entityStream, String contentType, ContentHandler tikaHandler) throws TikaParseException {
        try {
            ParseContext context = new ParseContext();
            Parser contextParser = this.appendEmbeddedContent ? this.parser : ((RecursiveParserWrapper)this.parser).getWrappedParser();
            context.set(Parser.class, (Object)contextParser);
            Metadata tikaMetadata = new Metadata();
            if (contentType != null) {
                tikaMetadata.set("Content-Type", contentType);
            }
            try (TikaInputStream tikaStream = TikaInputStream.get((InputStream)entityStream);){
                this.parser.parse((InputStream)tikaStream, tikaHandler, tikaMetadata, context);
                if (this.appendEmbeddedContent) {
                    TikaContent tikaContent = new TikaContent(tikaHandler == null ? null : tikaHandler.toString().trim(), TikaParser.convert(tikaMetadata));
                    return tikaContent;
                }
                RecursiveParserWrapperHandler rHandler = (RecursiveParserWrapperHandler)tikaHandler;
                List allMetadata = rHandler.getMetadataList();
                String mainDocumentText = ((Metadata)allMetadata.get(0)).get(AbstractRecursiveParserWrapperHandler.TIKA_CONTENT);
                LinkedList<TikaContent> embeddedContent = new LinkedList<TikaContent>();
                for (int i = 1; i < allMetadata.size(); ++i) {
                    String embeddedText = ((Metadata)allMetadata.get(i)).get(AbstractRecursiveParserWrapperHandler.TIKA_CONTENT);
                    if (embeddedText == null) continue;
                    embeddedContent.add(new TikaContent(embeddedText.trim(), TikaParser.convert((Metadata)allMetadata.get(i))));
                }
                TikaContent tikaContent = new TikaContent(mainDocumentText, TikaParser.convert((Metadata)allMetadata.get(0)), embeddedContent);
                return tikaContent;
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to parse the stream" + (String)(contentType == null ? "" : " for content-type: " + contentType);
            throw new TikaParseException(errorMessage, e);
        }
    }

    private ContentHandler validateContentHandler(ContentHandler contentHandler) {
        if (!this.appendEmbeddedContent && !(contentHandler instanceof RecursiveParserWrapperHandler)) {
            throw new IllegalStateException("The main document and every embedded document will require a unique ContentHandler instance");
        }
        return contentHandler;
    }

    private ContentHandler createContentHandler() {
        return this.appendEmbeddedContent ? new ToTextContentHandler() : new RecursiveParserWrapperHandler((ContentHandlerFactory)new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.TEXT, -1));
    }

    private ContentHandler createContentHandlerForMetadataOnly(String contentType) {
        if (this.appendEmbeddedContent) {
            return contentType != null && contentType.contains("pdf") ? null : new DefaultHandler();
        }
        return new RecursiveParserWrapperHandler((ContentHandlerFactory)new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.IGNORE, -1));
    }

    private static TikaMetadata convert(Metadata tikaMetadata) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String name : tikaMetadata.names()) {
            map.put(name, Arrays.asList(tikaMetadata.getValues(name)));
        }
        return new TikaMetadata(map);
    }
}

