/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash.devservices;

import io.quarkiverse.unleash.UnleashBuildTimeConfig;
import io.quarkiverse.unleash.devservices.ContainerLogger;
import io.quarkiverse.unleash.devservices.ContainerShutdownCloseable;
import io.quarkiverse.unleash.devservices.UnleashDbDevServicesProviderBuildItem;
import io.quarkiverse.unleash.devservices.UnleashDevServicesConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class UnleashDevServiceProcessor {
    private static final Logger log = Logger.getLogger(UnleashDevServiceProcessor.class);
    private static final String DEFAULT_DOCKER_IMAGE = "unleashorg/unleash-server:5.9.3";
    private static final String IMPORT_FILE_PATH = "/tmp/unleash-import-file.yml";
    public static final String PROP_UNLEASH_URL = "quarkus.unleash.url";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-unleash";
    public static final int DEFAULT_UNLEASH_PORT = 4242;
    private static final ContainerLocator unleashContainerLocator = new ContainerLocator("quarkus-dev-service-unleash", 4242);
    static volatile UnleashRunningDevService devService;
    static volatile UnleashDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startUnleashContainers(LaunchModeBuildItem launchMode, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, UnleashBuildTimeConfig buildTimeConfig, UnleashDbDevServicesProviderBuildItem dbSettings, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, DockerStatusBuildItem dockerStatusBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        UnleashDevServiceCfg configuration = this.getConfiguration(buildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.stopContainer();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Unleash Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startContainer(dockerStatusBuildItem, configuration, dbSettings, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.stopContainer();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            String tmp = (String)devService.getConfig().get(PROP_UNLEASH_URL);
            log.infof("The unleash is ready to accept connections on %s", (Object)tmp);
            log.infof("The unleash admin URL %s", (Object)tmp.replaceAll("api", ""));
        }
        return devService.toBuildItem();
    }

    private UnleashRunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, UnleashDevServiceCfg config, UnleashDbDevServicesProviderBuildItem dbSettings, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting dev services for Unleash as it has been disabled in the config");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)PROP_UNLEASH_URL)) {
            log.debug((Object)"Not starting dev services for Unleash as 'quarkus.unleash.url' have been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the unleash URL property (quarkus.unleash.url).");
            return null;
        }
        Optional maybeContainerAddress = unleashContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<UnleashRunningDevService> defaultUnleashSupplier = () -> {
            DockerImageName image = DockerImageName.parse((String)config.imageName);
            UnleashContainer container = new UnleashContainer(image, config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork, config.importFile, dbSettings);
            timeout.ifPresent(arg_0 -> ((UnleashContainer)container).withStartupTimeout(arg_0));
            if (config.log) {
                container.withLogConsumer((Consumer)((Object)ContainerLogger.create(config.serviceName)));
            }
            if (config.reuse) {
                container.withReuse(true);
            }
            container.start();
            String adminClient = container.getExternalAddress(4242);
            return new UnleashRunningDevService("unleash", container.getContainerId(), new ContainerShutdownCloseable(container, "unleash"), UnleashDevServiceProcessor.configMap(container.getUrl(), adminClient));
        };
        return maybeContainerAddress.map(containerAddress -> new UnleashRunningDevService("unleash", containerAddress.getId(), null, UnleashDevServiceProcessor.configMap(containerAddress.getUrl(), null))).orElseGet(defaultUnleashSupplier);
    }

    private static Map<String, String> configMap(String url, String adminClient) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(PROP_UNLEASH_URL, url);
        if (adminClient != null) {
            config.put("quarkiverse.unleash.devservices.admin.url", adminClient);
        }
        return config;
    }

    private void stopContainer() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Zeebe broker", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private UnleashDevServiceCfg getConfiguration(UnleashBuildTimeConfig cfg) {
        UnleashDevServicesConfig devServicesConfig = cfg.devService();
        return new UnleashDevServiceCfg(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class UnleashDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final String importFile;
        private final boolean reuse;
        private final boolean log;

        public UnleashDevServiceCfg(UnleashDevServicesConfig config) {
            this.devServicesEnabled = config.enabled();
            this.imageName = config.imageName().orElse(UnleashDevServiceProcessor.DEFAULT_DOCKER_IMAGE);
            this.fixedExposedPort = config.port().orElse(0);
            this.shared = config.shared();
            this.serviceName = config.serviceName();
            this.reuse = config.reuse();
            this.importFile = config.importFile().orElse(null);
            this.log = config.log();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnleashDevServiceCfg that = (UnleashDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    public static class UnleashRunningDevService
    extends DevServicesResultBuildItem.RunningDevService {
        public UnleashRunningDevService(String name, String containerId, Closeable closeable, Map<String, String> config) {
            super(name, containerId, closeable, config);
        }
    }

    private static class UnleashContainer
    extends GenericContainer<UnleashContainer> {
        private final boolean useSharedNetwork;
        private final int fixedExposedPort;
        private String hostName = null;

        public UnleashContainer(DockerImageName image, int fixedExposedPort, String serviceName, boolean useSharedNetwork, String importFile, UnleashDbDevServicesProviderBuildItem dbSettings) {
            super(image);
            log.debugf("Unleash docker image %s", (Object)image);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.withExposedPorts(new Integer[]{4242});
            ((UnleashContainer)((UnleashContainer)((UnleashContainer)((UnleashContainer)((UnleashContainer)((UnleashContainer)((UnleashContainer)this.withEnv("DATABASE_HOST", dbSettings.host)).withEnv("LOG_LEVEL", "info")).withEnv("DATABASE_NAME", dbSettings.name)).withEnv("DATABASE_USERNAME", dbSettings.username)).withEnv("DATABASE_PASSWORD", dbSettings.password)).withEnv("DATABASE_PORT", "" + dbSettings.port)).withEnv("AUTH_TYPE", "none")).withEnv("DATABASE_SSL", "false");
            if (serviceName != null) {
                this.withLabel(UnleashDevServiceProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            if (importFile != null) {
                log.infof("Unleash startup import file: %s", (Object)importFile);
                this.withEnv("IMPORT_FILE", UnleashDevServiceProcessor.IMPORT_FILE_PATH);
                this.withFileSystemBind(importFile, UnleashDevServiceProcessor.IMPORT_FILE_PATH, BindMode.READ_ONLY);
            }
            this.waitingFor((WaitStrategy)Wait.forHttp((String)"/"));
        }

        public String getExternalAddress(int port) {
            return this.getHost() + ":" + this.getMappedPort(port);
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"unleash");
                return;
            }
            this.withNetwork(Network.SHARED);
            if (this.fixedExposedPort > 0) {
                this.addFixedExposedPort(this.fixedExposedPort, 4242);
            } else {
                this.addExposedPort(4242);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 4242;
            }
            if (this.fixedExposedPort > 0) {
                return this.fixedExposedPort;
            }
            return super.getFirstMappedPort();
        }

        public String getUnleashHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }

        public String getUrl() {
            return String.format("http://%s:%d/api", this.getUnleashHost(), this.getPort());
        }
    }
}

