/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;

public class UnleashAdmin {
    private static final String PRJ = "default";
    private static final String ENV = "default";
    RequestSpecification request;

    public UnleashAdmin(String adminUrl) {
        this.request = RestAssured.given().baseUri(adminUrl).request().contentType(ContentType.JSON);
    }

    public void debug() {
        this.request = (RequestSpecification)this.request.log().all();
    }

    public void toggleOn(String feature) {
        this.toggleOn("default", feature, "default");
    }

    public void toggleOn(String project, String feature, String environment) {
        this.toggle(project, feature, environment, "on");
    }

    public void toggleOff(String feature) {
        this.toggleOff("default", feature, "default");
    }

    public void toggleOff(String project, String feature, String environment) {
        this.toggle(project, feature, environment, "off");
    }

    private void toggle(String project, String feature, String environment, String status) {
        ((ValidatableResponse)((Response)this.request.post(this.urlToggle(project, feature, environment, status), new Object[0])).then()).statusCode(200);
    }

    private String urlProjects() {
        return "/admin/projects";
    }

    private String urlProject(String project) {
        return this.urlProjects() + "/" + project;
    }

    private String urlFeatures(String project) {
        return this.urlProject(project) + "/features";
    }

    private String urlFeature(String project, String feature) {
        return this.urlFeatures(project) + "/" + feature;
    }

    private String urlEnvironments(String project, String feature) {
        return this.urlFeature(project, feature) + "/environments";
    }

    private String urlEnvironment(String project, String feature, String environment) {
        return this.urlEnvironments(project, feature) + "/" + environment;
    }

    private String urlToggle(String project, String feature, String environment, String status) {
        return this.urlEnvironment(project, feature, environment) + "/" + status;
    }
}

