/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash;

import io.getunleash.Unleash;
import io.quarkiverse.unleash.InjectUnleash;
import io.quarkiverse.unleash.InjectUnleashAdmin;
import io.quarkiverse.unleash.UnleashAdmin;
import io.quarkiverse.unleash.runtime.UnleashCreator;
import io.quarkiverse.unleash.runtime.UnleashRuntimeTimeConfig;
import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnleashTestResource
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    private static final Logger log = LoggerFactory.getLogger(UnleashTestResource.class);
    static UnleashAdmin ADMIN;
    static Unleash CLIENT;

    public Map<String, String> start() {
        return null;
    }

    public void stop() {
        try {
            CLIENT.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)ADMIN, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectUnleashAdmin.class, UnleashAdmin.class));
        testInjector.injectIntoFields((Object)CLIENT, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectUnleash.class, Unleash.class));
    }

    public void setIntegrationTestContext(DevServicesContext context) {
        String host = (String)context.devServicesProperties().get("quarkiverse.unleash.devservices.admin.url");
        if (host != null) {
            final String url = String.format("http://%s/api", host);
            ADMIN = new UnleashAdmin(url);
            final Config appConfig = ConfigProvider.getConfig();
            UnleashRuntimeTimeConfig configImpl = new UnleashRuntimeTimeConfig(){

                public boolean active() {
                    return false;
                }

                public String url() {
                    return url;
                }

                public Optional<String> appName() {
                    return Optional.of("quarkus-unleash-test");
                }

                public Optional<String> projectName() {
                    return appConfig.getOptionalValue("quarkus.unleash.project", String.class);
                }

                public Optional<String> instanceId() {
                    return Optional.of("quarkus-unleash-test-" + String.valueOf(UUID.randomUUID()));
                }

                public boolean disableMetrics() {
                    return true;
                }

                public Optional<String> token() {
                    return Optional.empty();
                }

                public Optional<String> environment() {
                    return Optional.empty();
                }

                public long fetchTogglesInterval() {
                    return appConfig.getOptionalValue("quarkus.unleash.fetch-toggles-interval", Long.class).orElse(2L);
                }

                public long sendMetricsInterval() {
                    return 606066066666666666L;
                }

                public Optional<String> backupFile() {
                    return Optional.empty();
                }

                public boolean synchronousFetchOnInitialisation() {
                    return true;
                }

                public boolean enableProxyAuthenticationByJvmProperties() {
                    return false;
                }

                public Optional<String> namePrefix() {
                    return Optional.empty();
                }
            };
            CLIENT = UnleashCreator.createUnleash((UnleashRuntimeTimeConfig)configImpl, (String)"quarkus-unleash-test");
            log.info("Unleash test client fetch feature toggle names: {}", (Object)CLIENT.more().getFeatureToggleNames());
        }
    }
}

