/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash.runtime;

import io.getunleash.Unleash;
import io.getunleash.Variant;
import io.getunleash.variant.Payload;
import io.quarkiverse.unleash.FeatureVariant;
import io.quarkiverse.unleash.UnleashJsonMapper;
import io.quarkus.logging.Log;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class AbstractVariantProducer {
    protected FeatureVariant getFeatureVariant(InjectionPoint injectionPoint) {
        FeatureVariant ft = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(FeatureVariant.class)) continue;
            ft = (FeatureVariant)qualifier;
            break;
        }
        return ft;
    }

    protected Variant getVariant(InjectionPoint injectionPoint, Unleash unleash) {
        FeatureVariant ft = this.getFeatureVariant(injectionPoint);
        return unleash.getVariant(ft.name());
    }

    protected String getVariantString(InjectionPoint injectionPoint, Unleash unleash) {
        Variant variant = this.getVariant(injectionPoint, unleash);
        if (variant == null || !variant.isEnabled()) {
            return null;
        }
        Optional payload = variant.getPayload();
        return payload.map(Payload::getValue).orElse(null);
    }

    protected Object getVariantJsonObject(InjectionPoint injectionPoint, Class<?> clazz, Unleash unleash, UnleashJsonMapper mapper) {
        FeatureVariant ft = this.getFeatureVariant(injectionPoint);
        Variant variant = unleash.getVariant(ft.name());
        if (variant == null || !variant.isEnabled()) {
            return null;
        }
        Optional tmp = variant.getPayload();
        if (tmp.isEmpty()) {
            return null;
        }
        Payload payload = (Payload)tmp.get();
        if (!payload.getType().equals("json")) {
            Log.warnf((String)"Feature toggle '%s' variant '%s' is not type of 'json'. Type: %s", (Object)ft.name(), (Object)variant.getName(), (Object)payload.getType());
            return null;
        }
        String value = payload.getValue();
        if (value == null) {
            return null;
        }
        return mapper.fromJson(value, clazz);
    }
}

