/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash.runtime;

import io.getunleash.DefaultUnleash;
import io.getunleash.Unleash;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.repository.ToggleBootstrapProvider;
import io.getunleash.strategy.Strategy;
import io.getunleash.util.UnleashConfig;
import io.getunleash.util.UnleashScheduledExecutor;
import io.getunleash.util.UnleashScheduledExecutorImpl;
import io.quarkiverse.unleash.runtime.UnleashRuntimeTimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;

public class UnleashCreator {
    public static Unleash createUnleash(UnleashRuntimeTimeConfig unleashRuntimeTimeConfig, String name) {
        ArcContainer arcContainer;
        UnleashConfig.Builder builder = UnleashConfig.builder().unleashAPI(unleashRuntimeTimeConfig.url()).appName(name).scheduledExecutor((UnleashScheduledExecutor)new UnleashScheduledExecutorImpl());
        unleashRuntimeTimeConfig.instanceId().ifPresent(arg_0 -> ((UnleashConfig.Builder)builder).instanceId(arg_0));
        unleashRuntimeTimeConfig.token().ifPresent(s -> builder.customHttpHeader("Authorization", s));
        unleashRuntimeTimeConfig.environment().ifPresent(arg_0 -> ((UnleashConfig.Builder)builder).environment(arg_0));
        unleashRuntimeTimeConfig.projectName().ifPresent(arg_0 -> ((UnleashConfig.Builder)builder).projectName(arg_0));
        unleashRuntimeTimeConfig.backupFile().ifPresent(arg_0 -> ((UnleashConfig.Builder)builder).backupFile(arg_0));
        unleashRuntimeTimeConfig.namePrefix().ifPresent(arg_0 -> ((UnleashConfig.Builder)builder).namePrefix(arg_0));
        builder.fetchTogglesInterval(unleashRuntimeTimeConfig.fetchTogglesInterval());
        builder.sendMetricsInterval(unleashRuntimeTimeConfig.sendMetricsInterval());
        builder.synchronousFetchOnInitialisation(unleashRuntimeTimeConfig.synchronousFetchOnInitialisation());
        if (unleashRuntimeTimeConfig.enableProxyAuthenticationByJvmProperties()) {
            builder.enableProxyAuthenticationByJvmProperties();
        }
        if (unleashRuntimeTimeConfig.disableMetrics()) {
            builder.disableMetrics();
        }
        if ((arcContainer = Arc.container()) != null) {
            InstanceHandle toggleBootstrapProvider;
            InstanceHandle unleashSubscriber = arcContainer.instance(UnleashSubscriber.class, new Annotation[0]);
            if (unleashSubscriber.isAvailable()) {
                builder.subscriber((UnleashSubscriber)unleashSubscriber.get());
            }
            if ((toggleBootstrapProvider = arcContainer.instance(ToggleBootstrapProvider.class, new Annotation[0])).isAvailable()) {
                builder.toggleBootstrapProvider((ToggleBootstrapProvider)toggleBootstrapProvider.get());
            }
        }
        return new DefaultUnleash(builder.build(), new Strategy[0]);
    }
}

