/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash.runtime;

import io.getunleash.Unleash;
import io.quarkiverse.unleash.runtime.NoOpUnleash;
import io.quarkiverse.unleash.runtime.UnleashCreator;
import io.quarkiverse.unleash.runtime.UnleashRuntimeTimeConfig;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class UnleashRecorder {
    private static final Logger LOGGER = Logger.getLogger(UnleashRecorder.class);
    private final ApplicationConfig applicationConfig;
    private final RuntimeValue<UnleashRuntimeTimeConfig> unleashRuntimeConfig;

    public UnleashRecorder(ApplicationConfig applicationConfig, RuntimeValue<UnleashRuntimeTimeConfig> unleashRuntimeConfig) {
        this.applicationConfig = applicationConfig;
        this.unleashRuntimeConfig = unleashRuntimeConfig;
    }

    public Supplier<Unleash> getSupplier() {
        if (((UnleashRuntimeTimeConfig)this.unleashRuntimeConfig.getValue()).active()) {
            final String app = ((UnleashRuntimeTimeConfig)this.unleashRuntimeConfig.getValue()).appName().orElse(this.applicationConfig.name.orElse("default-app-name"));
            return new Supplier<Unleash>(){

                @Override
                public Unleash get() {
                    Unleash unleash = UnleashCreator.createUnleash((UnleashRuntimeTimeConfig)UnleashRecorder.this.unleashRuntimeConfig.getValue(), app);
                    LOGGER.infof("Unleash client application '%s' fetch feature toggle names: %s", (Object)app, (Object)unleash.more().getFeatureToggleNames());
                    return unleash;
                }
            };
        }
        return new Supplier<Unleash>(){

            @Override
            public Unleash get() {
                LOGGER.info((Object)"Unleash extension disabled from configuration");
                return new NoOpUnleash();
            }
        };
    }
}

