/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.test;

import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultIOException;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.sys.VaultInitResponse;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultSealStatusResult;
import io.quarkus.vault.runtime.config.VaultAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import io.quarkus.vault.runtime.config.VaultEnterpriseConfig;
import io.quarkus.vault.runtime.config.VaultKubernetesAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultTlsConfig;
import io.quarkus.vault.test.client.TestVaultClient;
import io.quarkus.vault.test.client.dto.VaultAppRoleRoleId;
import io.quarkus.vault.test.client.dto.VaultAppRoleRoleIdData;
import io.quarkus.vault.test.client.dto.VaultAppRoleSecretId;
import io.quarkus.vault.test.client.dto.VaultAppRoleSecretIdData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.containers.output.OutputFrame;

public class VaultTestExtension {
    private static final Logger log = Logger.getLogger((String)VaultTestExtension.class.getName());
    static final String DB_NAME = "mydb";
    static final String DB_USERNAME = "postgres";
    public static final String DB_PASSWORD = "bar";
    static final String RMQ_USERNAME = "guest";
    public static final String RMQ_PASSWORD = "yXvOzyOPE";
    public static final String SECRET_VALUE = "s\u20accr\u20act";
    static final int VAULT_PORT = 8200;
    static final int MAPPED_POSTGRESQL_PORT = 6543;
    public static final String VAULT_AUTH_USERPASS_USER = "bob";
    public static final String VAULT_AUTH_USERPASS_PASSWORD = "sinclair";
    public static final String VAULT_AUTH_APPROLE = "myapprole";
    public static final String SECRET_PATH_V1 = "secret-v1";
    public static final String SECRET_PATH_V2 = "secret";
    public static final String LIST_PATH = "hello";
    public static final String LIST_SUB_PATH = "world";
    public static final String EXPECTED_SUB_PATHS = "[world]";
    public static final String VAULT_DBROLE = "mydbrole";
    public static final String VAULT_RMQROLE = "myrabbitmqrole";
    public static final String APP_SECRET_PATH = "foo";
    static final String APP_CONFIG_PATH = "config";
    static final String VAULT_POLICY = "mypolicy";
    static final String POSTGRESQL_HOST = "mypostgresdb";
    static final String RABBITMQ_HOST = "myrabbitmq";
    static final String VAULT_URL = (VaultTestExtension.useTls() ? "https" : "http") + "://localhost:8200";
    public static final String SECRET_KEY = "secret";
    public static final String ENCRYPTION_KEY_NAME = "my-encryption-key";
    public static final String ENCRYPTION_KEY2_NAME = "my-encryption-key2";
    public static final String ENCRYPTION_DERIVED_KEY_NAME = "my-derivation-encryption-key";
    public static final String SIGN_KEY_NAME = "my-sign-key";
    public static final String SIGN_KEY2_NAME = "my-sign-key2";
    public static final String SIGN_DERIVATION_KEY_NAME = "my-derivation-sign-key";
    public static final String TMP_VAULT_POSTGRES_CREATION_SQL_FILE = "/tmp/vault-postgres-creation.sql";
    public static final String TMP_VAULT_CONFIG_JSON_FILE = "/tmp/vault-config.json";
    public static final String TMP_POSTGRES_INIT_SQL_FILE = "/tmp/postgres-init.sql";
    public static final String TEST_QUERY_STRING = "SELECT 1";
    public static final String CONTAINER_TMP_CMD = "/tmp/cmd";
    public static final String HOST_VAULT_TMP_CMD = "target/vault_cmd";
    public static final String HOST_POSTGRES_TMP_CMD = "target/postgres_cmd";
    public static final String OUT_FILE = "/out";
    public static final String WRAPPING_TEST_PATH = "wrapping-test";
    private static String CRUD_PATH = "crud";
    public GenericContainer vaultContainer;
    public PostgreSQLContainer postgresContainer;
    public RabbitMQContainer rabbitMQContainer;
    public String rootToken = null;
    public String appRoleSecretId = null;
    public String appRoleRoleId = null;
    public String appRoleSecretIdWrappingToken = null;
    public String clientTokenWrappingToken = null;
    public String passwordKvv1WrappingToken = null;
    public String passwordKvv2WrappingToken = null;
    public String anotherPasswordKvv2WrappingToken = null;
    private TestVaultClient vaultClient;
    private String db_default_ttl = "1m";
    private String db_max_ttl = "10m";

    public static void testDataSource(DataSource ds) throws SQLException {
        try (Connection c = ds.getConnection();
             Statement stmt = c.createStatement();
             ResultSet rs = stmt.executeQuery(TEST_QUERY_STRING);){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    public static void assertCrudSecret(VaultKVSecretEngine kvSecretEngine) {
        Assertions.assertEquals((Object)EXPECTED_SUB_PATHS, (Object)kvSecretEngine.listSecrets(LIST_PATH).toString());
        VaultTestExtension.assertDeleteSecret(kvSecretEngine);
        VaultTestExtension.assertDeleteSecret(kvSecretEngine);
        HashMap<String, String> newsecrets = new HashMap<String, String>();
        newsecrets.put("first", "one");
        newsecrets.put("second", "two");
        kvSecretEngine.writeSecret(CRUD_PATH, newsecrets);
        Assertions.assertEquals((Object)"{first=one, second=two}", (Object)VaultTestExtension.readSecretAsString(kvSecretEngine, CRUD_PATH));
        newsecrets.put("first", "un");
        newsecrets.put("third", "tres");
        kvSecretEngine.writeSecret(CRUD_PATH, newsecrets);
        Assertions.assertEquals((Object)"{first=un, second=two, third=tres}", (Object)VaultTestExtension.readSecretAsString(kvSecretEngine, CRUD_PATH));
        VaultTestExtension.assertDeleteSecret(kvSecretEngine);
    }

    private static void assertDeleteSecret(VaultKVSecretEngine kvSecretEngine) {
        kvSecretEngine.deleteSecret(CRUD_PATH);
        try {
            VaultTestExtension.readSecretAsString(kvSecretEngine, CRUD_PATH);
        }
        catch (VaultClientException e) {
            Assertions.assertEquals((int)404, (int)e.getStatus());
        }
    }

    private static String readSecretAsString(VaultKVSecretEngine kvSecretEngine, String path) {
        Map secret = kvSecretEngine.readSecret(path);
        return new TreeMap(secret).toString();
    }

    private TestVaultClient createVaultClient() {
        VaultBootstrapConfig vaultBootstrapConfig = new VaultBootstrapConfig();
        vaultBootstrapConfig.tls = new VaultTlsConfig();
        vaultBootstrapConfig.url = VaultTestExtension.getVaultUrl();
        vaultBootstrapConfig.enterprise = new VaultEnterpriseConfig();
        vaultBootstrapConfig.enterprise.namespace = Optional.empty();
        vaultBootstrapConfig.tls.skipVerify = Optional.of(true);
        vaultBootstrapConfig.tls.caCert = Optional.empty();
        vaultBootstrapConfig.connectTimeout = Duration.ofSeconds(30L);
        vaultBootstrapConfig.readTimeout = Duration.ofSeconds(5L);
        vaultBootstrapConfig.nonProxyHosts = Optional.empty();
        vaultBootstrapConfig.authentication = new VaultAuthenticationConfig();
        vaultBootstrapConfig.authentication.kubernetes = new VaultKubernetesAuthenticationConfig();
        return new TestVaultClient(new VaultConfigHolder().setVaultBootstrapConfig(vaultBootstrapConfig));
    }

    private static Optional<URL> getVaultUrl() {
        try {
            return Optional.of(new URL(VAULT_URL));
        }
        catch (MalformedURLException e) {
            throw new VaultException((Throwable)e);
        }
    }

    public void start() throws InterruptedException, IOException {
        log.info((Object)("start containers on " + System.getProperty("os.name")));
        new File(HOST_POSTGRES_TMP_CMD).mkdirs();
        Network network = Network.newNetwork();
        this.postgresContainer = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer().withDatabaseName(DB_NAME).withUsername(DB_USERNAME).withPassword(DB_PASSWORD).withNetwork(network)).withFileSystemBind(HOST_POSTGRES_TMP_CMD, CONTAINER_TMP_CMD)).withNetworkAliases(new String[]{POSTGRESQL_HOST})).withExposedPorts(new Integer[]{PostgreSQLContainer.POSTGRESQL_PORT})).withClasspathResourceMapping("postgres-init.sql", TMP_POSTGRES_INIT_SQL_FILE, BindMode.READ_ONLY);
        this.postgresContainer.setPortBindings(Arrays.asList("6543:" + PostgreSQLContainer.POSTGRESQL_PORT));
        this.rabbitMQContainer = (RabbitMQContainer)((RabbitMQContainer)new RabbitMQContainer().withAdminPassword(RMQ_PASSWORD).withNetwork(network)).withNetworkAliases(new String[]{RABBITMQ_HOST});
        String configFile = VaultTestExtension.useTls() ? "vault-config-tls.json" : "vault-config.json";
        String vaultImage = this.getVaultImage();
        log.info((Object)("starting " + vaultImage + " with url=" + VAULT_URL + " and config file=" + configFile));
        new File(HOST_VAULT_TMP_CMD).mkdirs();
        this.vaultContainer = ((GenericContainer)new GenericContainer(vaultImage).withExposedPorts(new Integer[]{8200}).withEnv("SKIP_SETCAP", "true").withEnv("VAULT_SKIP_VERIFY", "true").withEnv("VAULT_ADDR", VAULT_URL).withNetwork(network).withFileSystemBind(HOST_VAULT_TMP_CMD, CONTAINER_TMP_CMD)).withClasspathResourceMapping(configFile, TMP_VAULT_CONFIG_JSON_FILE, BindMode.READ_ONLY).withClasspathResourceMapping("vault-tls.key", "/tmp/vault-tls.key", BindMode.READ_ONLY).withClasspathResourceMapping("vault-tls.crt", "/tmp/vault-tls.crt", BindMode.READ_ONLY).withClasspathResourceMapping("vault-postgres-creation.sql", TMP_VAULT_POSTGRES_CREATION_SQL_FILE, BindMode.READ_ONLY).withCommand(new String[]{"server", "-log-level=debug", "-config=/tmp/vault-config.json"});
        this.vaultContainer.setPortBindings(Arrays.asList("8200:8200"));
        this.postgresContainer.start();
        this.execPostgres(String.format("psql -U %s -d %s -f %s", DB_USERNAME, DB_NAME, TMP_POSTGRES_INIT_SQL_FILE));
        this.rabbitMQContainer.start();
        Consumer<OutputFrame> consumer = outputFrame -> System.out.print("VAULT >> " + outputFrame.getUtf8String());
        this.vaultContainer.setLogConsumers(Arrays.asList(consumer));
        this.vaultContainer.start();
        this.initVault();
        log.info((Object)("vault has started with root token: " + this.rootToken));
    }

    private String getVaultImage() {
        return "vault:1.10.0";
    }

    private void initVault() throws InterruptedException, IOException {
        this.waitForContainerToStart();
        this.vaultClient = this.createVaultClient();
        VaultInternalSystemBackend vaultInternalSystemBackend = new VaultInternalSystemBackend();
        this.waitForVaultAPIToBeReady(vaultInternalSystemBackend);
        VaultInitResponse vaultInit = (VaultInitResponse)vaultInternalSystemBackend.init((VaultClient)this.vaultClient, 1, 1).await().indefinitely();
        String unsealKey = (String)vaultInit.keys.get(0);
        this.rootToken = vaultInit.rootToken;
        try {
            vaultInternalSystemBackend.systemHealthStatus((VaultClient)this.vaultClient, false, false).await().indefinitely();
        }
        catch (VaultClientException e) {
            Assertions.assertEquals((int)503, (int)e.getStatus());
        }
        this.execVault("vault operator unseal " + unsealKey);
        VaultSealStatusResult sealStatus = (VaultSealStatusResult)vaultInternalSystemBackend.systemSealStatus((VaultClient)this.vaultClient).await().indefinitely();
        Assertions.assertFalse((boolean)sealStatus.sealed);
        this.execVault("vault auth enable userpass");
        this.execVault(String.format("vault write auth/userpass/users/%s password=%s policies=%s", VAULT_AUTH_USERPASS_USER, VAULT_AUTH_USERPASS_PASSWORD, VAULT_POLICY));
        this.execVault("vault auth enable kubernetes");
        this.execVault("vault auth enable approle");
        this.execVault(String.format("vault write auth/approle/role/%s policies=%s", VAULT_AUTH_APPROLE, VAULT_POLICY));
        this.appRoleSecretId = ((VaultAppRoleSecretIdData)((VaultAppRoleSecretId)((Object)this.vaultClient.generateAppRoleSecretId((String)this.rootToken, (String)VAULT_AUTH_APPROLE).await().indefinitely())).data).secretId;
        this.appRoleRoleId = ((VaultAppRoleRoleIdData)((VaultAppRoleRoleId)((Object)this.vaultClient.getAppRoleRoleId((String)this.rootToken, (String)VAULT_AUTH_APPROLE).await().indefinitely())).data).roleId;
        log.info((Object)String.format("generated role_id=%s secret_id=%s for approle=%s", this.appRoleRoleId, this.appRoleSecretId, VAULT_AUTH_APPROLE));
        String policyContent = this.readResourceContent("vault.policy");
        vaultInternalSystemBackend.createUpdatePolicy((VaultClient)this.vaultClient, this.rootToken, VAULT_POLICY, new VaultPolicyBody(policyContent)).await().indefinitely();
        this.execVault(String.format("vault secrets enable -path=%s kv", SECRET_PATH_V1));
        this.execVault(String.format("vault kv put %s/%s %s=%s", SECRET_PATH_V1, APP_SECRET_PATH, "secret", SECRET_VALUE));
        this.execVault(String.format("vault kv put %s/%s %s=%s", SECRET_PATH_V1, "hello/world", "secret", SECRET_VALUE));
        this.execVault(String.format("vault kv put %s/%s %s=%s", SECRET_PATH_V1, APP_CONFIG_PATH, "password", DB_PASSWORD));
        this.execVault(String.format("vault secrets enable -path=%s -version=2 kv", "secret"));
        this.execVault(String.format("vault kv put %s/%s %s=%s", "secret", APP_SECRET_PATH, "secret", SECRET_VALUE));
        this.execVault(String.format("vault kv put %s/%s %s=%s", "secret", "hello/world", "secret", SECRET_VALUE));
        this.execVault(String.format("vault kv put %s/%s %s=%s", "secret", APP_CONFIG_PATH, "password", DB_PASSWORD));
        this.execVault(String.format("vault kv put %s/multi/default1 color=blue size=XL", "secret"));
        this.execVault(String.format("vault kv put %s/multi/default2 color=red weight=3", "secret"));
        this.execVault(String.format("vault kv put %s/multi/singer1 firstname=paul lastname=shaffer", "secret"));
        this.execVault(String.format("vault kv put %s/multi/singer2 lastname=simon age=78 color=green", "secret"));
        this.appRoleSecretIdWrappingToken = this.fetchWrappingToken(this.execVault(String.format("vault write -wrap-ttl=120s -f auth/approle/role/%s/secret-id", VAULT_AUTH_APPROLE)));
        log.info((Object)("appRoleSecretIdWrappingToken=" + this.appRoleSecretIdWrappingToken));
        this.clientTokenWrappingToken = this.fetchWrappingToken(this.execVault(String.format("vault token create -wrap-ttl=120s -ttl=10m -policy=%s", VAULT_POLICY)));
        log.info((Object)("clientTokenWrappingToken=" + this.clientTokenWrappingToken));
        this.execVault(String.format("vault kv put %s/%s %s=%s", SECRET_PATH_V1, WRAPPING_TEST_PATH, "password", VAULT_AUTH_USERPASS_PASSWORD));
        this.passwordKvv1WrappingToken = this.fetchWrappingToken(this.execVault(String.format("vault kv get -wrap-ttl=120s %s/%s", SECRET_PATH_V1, WRAPPING_TEST_PATH)));
        log.info((Object)("passwordKvv1WrappingToken=" + this.passwordKvv1WrappingToken));
        this.execVault(String.format("vault kv put %s/%s %s=%s", "secret", WRAPPING_TEST_PATH, "password", VAULT_AUTH_USERPASS_PASSWORD));
        this.passwordKvv2WrappingToken = this.fetchWrappingToken(this.execVault(String.format("vault kv get -wrap-ttl=120s %s/%s", "secret", WRAPPING_TEST_PATH)));
        log.info((Object)("passwordKvv2WrappingToken=" + this.passwordKvv2WrappingToken));
        this.anotherPasswordKvv2WrappingToken = this.fetchWrappingToken(this.execVault(String.format("vault kv get -wrap-ttl=120s %s/%s", "secret", WRAPPING_TEST_PATH)));
        log.info((Object)("anotherPasswordKvv2WrappingToken=" + this.anotherPasswordKvv2WrappingToken));
        this.execVault("vault secrets enable database");
        String vault_write_database_config_mydb = String.format("vault write database/config/%s plugin_name=postgresql-database-plugin allowed_roles=%s connection_url=postgresql://{{username}}:{{password}}@%s:%s/%s?sslmode=disable username=%s password=%s", DB_NAME, VAULT_DBROLE, POSTGRESQL_HOST, PostgreSQLContainer.POSTGRESQL_PORT, DB_NAME, DB_USERNAME, DB_PASSWORD);
        this.execVault(vault_write_database_config_mydb);
        String vault_write_database_roles_mydbrole = String.format("vault write database/roles/%s db_name=%s creation_statements=@%s default_ttl=%s max_ttl=%s revocation_statements=\"ALTER ROLE \\\"{{name}}\\\" NOLOGIN;\" renew_statements=\"ALTER ROLE \\\"{{name}}\\\" VALID UNTIL '{{expiration}}';\"", VAULT_DBROLE, DB_NAME, TMP_VAULT_POSTGRES_CREATION_SQL_FILE, this.db_default_ttl, this.db_max_ttl);
        this.execVault(vault_write_database_roles_mydbrole);
        this.execVault("vault secrets enable rabbitmq");
        String vault_write_rabbitmq_config = String.format("vault write rabbitmq/config/connection connection_uri=http://%s:15672 username=%s password=%s", RABBITMQ_HOST, RMQ_USERNAME, RMQ_PASSWORD);
        this.execVault(vault_write_rabbitmq_config);
        String vault_write_rabbitmq_roles_myrabbitmqrole = String.format("vault write rabbitmq/roles/%s vhosts='{\"/\":{\"configure\":\".*\", \"write\":\".*\", \"read\":\".*\"}}' default_ttl=%s max_ttl=%s", VAULT_RMQROLE, this.db_default_ttl, this.db_max_ttl);
        this.execVault(vault_write_rabbitmq_roles_myrabbitmqrole);
        this.execVault("vault secrets enable transit");
        this.execVault(String.format("vault write -f transit/keys/%s", ENCRYPTION_KEY_NAME));
        this.execVault(String.format("vault write -f transit/keys/%s", ENCRYPTION_KEY2_NAME));
        this.execVault(String.format("vault write transit/keys/%s derived=true", ENCRYPTION_DERIVED_KEY_NAME));
        this.execVault(String.format("vault write transit/keys/%s type=ecdsa-p256", SIGN_KEY_NAME));
        this.execVault(String.format("vault write transit/keys/%s type=rsa-2048", SIGN_KEY2_NAME));
        this.execVault(String.format("vault write transit/keys/%s type=ed25519 derived=true", SIGN_DERIVATION_KEY_NAME));
        this.execVault("vault write transit/keys/jws type=ecdsa-p256");
        this.execVault("vault secrets enable totp");
        this.execVault("vault secrets enable pki");
        this.execVault("vault secrets enable -path=pki2 pki");
        this.execVault("vault secrets tune -max-lease-ttl=8760h pki");
        this.execVault("vault token create -policy=root -id=pkiroot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResourceContent(String path) throws IOException {
        byte[] buf = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            int count;
            while ((count = in.read(buf)) > 0) {
                baos.write(buf, 0, count);
            }
        }
        return new String(baos.toByteArray());
    }

    private String fetchWrappingToken(String out) {
        Pattern wrappingTokenPattern = Pattern.compile("^wrapping_token:\\s+([^\\s]+)$", 8);
        Matcher matcher = wrappingTokenPattern.matcher(out);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new RuntimeException("unable to find wrapping_token in " + out);
    }

    public static boolean useTls() {
        return System.getProperty("vault-test-extension.use-tls", Boolean.TRUE.toString()).equals(Boolean.TRUE.toString());
    }

    private void waitForContainerToStart() throws InterruptedException, IOException {
        Instant started = Instant.now();
        while (Instant.now().isBefore(started.plusSeconds(20L))) {
            Container.ExecResult vault_status = this.vaultContainer.execInContainer(this.createVaultCommand("vault status"));
            int exitCode = vault_status.getExitCode();
            log.info((Object)("vault status exit code = " + exitCode + " (0=unsealed, 1=error, 2=sealed)"));
            if (exitCode == 2) {
                return;
            }
            Thread.sleep(1000L);
        }
        Assertions.fail((String)"vault failed to start");
    }

    private void waitForVaultAPIToBeReady(VaultInternalSystemBackend vaultInternalSystemBackend) throws InterruptedException {
        Instant started = Instant.now();
        while (Instant.now().isBefore(started.plusSeconds(20L))) {
            try {
                log.info((Object)"checking seal status");
                VaultSealStatusResult sealStatus = (VaultSealStatusResult)vaultInternalSystemBackend.systemSealStatus((VaultClient)this.vaultClient).await().indefinitely();
                log.info((Object)sealStatus);
                return;
            }
            catch (VaultIOException e) {
                log.info((Object)("vault api not ready: " + e));
                Thread.sleep(1000L);
            }
        }
        Assertions.fail((String)"vault failed to start");
    }

    private String execPostgres(String command) throws IOException, InterruptedException {
        String[] cmd = new String[]{"/bin/sh", "-c", command + " > /tmp/cmd/out"};
        return this.exec((GenericContainer)this.postgresContainer, command, cmd, "target/postgres_cmd/out");
    }

    private String execVault(String command) throws IOException, InterruptedException {
        String[] cmd = this.createVaultCommand(command + " > /tmp/cmd/out");
        return this.exec(this.vaultContainer, command, cmd, "target/vault_cmd/out");
    }

    private String exec(GenericContainer container, String command, String[] cmd, String outFile) throws IOException, InterruptedException {
        VaultTestExtension.exec(container, cmd);
        String out = Files.readString(Paths.get(outFile, new String[0]));
        log.info((Object)("> " + command + "\n" + out));
        return out;
    }

    private static Container.ExecResult exec(GenericContainer container, String[] cmd) throws IOException, InterruptedException {
        Container.ExecResult execResult = container.execInContainer(cmd);
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("command " + Arrays.asList(cmd) + " failed with exit code " + execResult.getExitCode() + "\n" + execResult.getStderr());
        }
        return execResult;
    }

    private String[] createVaultCommand(String command) {
        String cmd = (String)(this.rootToken != null ? "export VAULT_TOKEN=" + this.rootToken + " && " : "") + command;
        return new String[]{"/bin/sh", "-c", cmd};
    }

    public void close() {
        log.info((Object)"stop containers");
        if (this.vaultContainer != null && this.vaultContainer.isRunning()) {
            this.vaultContainer.stop();
        }
        if (this.postgresContainer != null && this.postgresContainer.isRunning()) {
            this.postgresContainer.stop();
        }
        if (this.rabbitMQContainer != null && this.rabbitMQContainer.isRunning()) {
            this.rabbitMQContainer.stop();
        }
    }
}

