/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.test;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.vault.test.VaultTestExtension;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class VaultTestLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final Logger log = Logger.getLogger(VaultTestLifecycleManager.class);
    protected VaultTestExtension vaultTestExtension;
    public static final String GRAALVM_JRE_LIB_AMD_64 = "/opt/graalvm/jre/lib/amd64";

    public Map<String, String> start() {
        this.vaultTestExtension = new VaultTestExtension();
        HashMap<String, String> sysprops = new HashMap<String, String>();
        if (VaultTestExtension.useTls()) {
            sysprops.put("javax.net.ssl.trustStore", "src/test/resources/vaultTrustStore");
            sysprops.put("java.library.path", GRAALVM_JRE_LIB_AMD_64);
        }
        try {
            this.vaultTestExtension.start();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        sysprops.put("vault-test.role-id", this.vaultTestExtension.appRoleRoleId);
        sysprops.put("vault-test.secret-id", this.vaultTestExtension.appRoleSecretId);
        sysprops.put("vault-test.secret-id-wrapping-token", this.vaultTestExtension.appRoleSecretIdWrappingToken);
        sysprops.put("vault-test.client-token-wrapping-token", this.vaultTestExtension.clientTokenWrappingToken);
        sysprops.put("vault-test.password-kv-v1-wrapping-token", this.vaultTestExtension.passwordKvv1WrappingToken);
        sysprops.put("vault-test.password-kv-v2-wrapping-token", this.vaultTestExtension.passwordKvv2WrappingToken);
        sysprops.put("vault-test.another-password-kv-v2-wrapping-token", this.vaultTestExtension.anotherPasswordKvv2WrappingToken);
        log.info((Object)("using system properties " + sysprops));
        return sysprops;
    }

    public void stop() {
        if (this.vaultTestExtension != null) {
            this.vaultTestExtension.close();
        }
    }
}

