/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.http.vertx;

import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.http.VaultHttpClient;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class VertxVaultHttpClient
extends VaultHttpClient {
    private static final HttpMethod LIST = HttpMethod.valueOf((String)"LIST");
    private final WebClient webClient;

    public VertxVaultHttpClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public <T> CompletionStage<VaultResponse<T>> execute(VaultRequest<T> request) {
        RequestOptions requestOptions = this.requestOptions(request);
        HttpRequest httpRequest = this.webClient.request(VertxVaultHttpClient.httpMethodFor(request), requestOptions);
        return this.send(request, (HttpRequest<Buffer>)httpRequest).thenCompose(res -> this.buildResponse(request, (HttpResponse<Buffer>)res));
    }

    private RequestOptions requestOptions(VaultRequest<?> request) {
        RequestOptions options = new RequestOptions().setTraceOperation(request.getOperation()).setAbsoluteURI(request.getUrl()).setTimeout(request.getTimeout().toMillis());
        request.getHTTPHeaders().forEach((arg_0, arg_1) -> ((RequestOptions)options).addHeader(arg_0, arg_1));
        return options;
    }

    private CompletionStage<HttpResponse<Buffer>> send(VaultRequest<?> request, HttpRequest<Buffer> httpRequest) {
        Future send = request.getSerializedBody().map(Buffer::buffer).map(arg_0 -> httpRequest.sendBuffer(arg_0)).orElseGet(() -> httpRequest.send());
        return send.toCompletionStage().exceptionallyCompose(e -> {
            if (e instanceof CompletionException || e instanceof ExecutionException) {
                e = e.getCause();
            }
            if ("Connection was closed".equals(e.getMessage())) {
                e = new VaultClientException(request, null, List.of("Connection was closed"), e);
            }
            return CompletableFuture.failedStage(e);
        });
    }

    private <T> CompletionStage<VaultResponse<T>> buildResponse(VaultRequest<T> request, HttpResponse<Buffer> res) {
        Buffer body = (Buffer)res.body();
        byte[] bodyData = body != null ? body.getBytes() : null;
        return this.buildResponse(request, res.statusCode(), VertxVaultHttpClient.headers(res), bodyData);
    }

    private static HttpMethod httpMethodFor(VaultRequest<?> request) {
        return switch (request.getMethod()) {
            default -> throw new IncompatibleClassChangeError();
            case VaultRequest.Method.LIST -> LIST;
            case VaultRequest.Method.GET -> HttpMethod.GET;
            case VaultRequest.Method.PUT -> HttpMethod.PUT;
            case VaultRequest.Method.POST -> HttpMethod.POST;
            case VaultRequest.Method.PATCH -> HttpMethod.PATCH;
            case VaultRequest.Method.DELETE -> HttpMethod.DELETE;
            case VaultRequest.Method.HEAD -> HttpMethod.HEAD;
        };
    }

    private static List<Map.Entry<String, String>> headers(HttpResponse<?> response) {
        return response.headers().entries();
    }

    public void close() {
        this.webClient.close();
    }
}

