/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.database;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseConfigParams;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseGenerateCredentialsResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseGenerateStaticRoleCredentialsResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseListConnectionsResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseListRolesResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseListStaticRolesResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseReadConnectionResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseReadRoleResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseReadStaticRoleResult;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseUpdateRoleParams;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseUpdateStaticRoleParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSecretsDatabaseRequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsDatabaseRequestFactory INSTANCE = new VaultSecretsDatabaseRequestFactory();

    public VaultSecretsDatabaseRequestFactory() {
        super("[SECRETS (database)]");
    }

    public VaultRequest<Void> configureConnection(String mountPath, String connectionName, VaultSecretsDatabaseConfigParams params) {
        return VaultRequest.post(this.getTraceOpName("Configure Connection")).path(mountPath, "config", connectionName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsDatabaseReadConnectionResult> readConnection(String mountPath, String connectionName) {
        return VaultRequest.get(this.getTraceOpName("Read Connection")).path(mountPath, "config", connectionName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseReadConnectionResult.class));
    }

    public VaultRequest<VaultSecretsDatabaseListConnectionsResult> listConnections(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("List Connections")).path(mountPath, "config").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseListConnectionsResult.class));
    }

    public VaultRequest<Void> deleteConnection(String mountPath, String connectionName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Connection")).path(mountPath, "config", connectionName).expectNoContentStatus().build();
    }

    public VaultRequest<Void> resetConnection(String mountPath, String connectionName) {
        return VaultRequest.post(this.getTraceOpName("Reset Connection")).path(mountPath, "reset", connectionName).expectNoContentStatus().build();
    }

    public VaultRequest<Void> rotateRootCredentials(String mountPath, String connectionName) {
        return VaultRequest.post(this.getTraceOpName("Rotate Root Credentials")).path(mountPath, "rotate-root", connectionName).expectNoContentStatus().build();
    }

    public VaultRequest<Void> updateRole(String mountPath, String roleName, VaultSecretsDatabaseUpdateRoleParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Role")).path(mountPath, "roles", roleName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsDatabaseReadRoleResult> readRole(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role")).path(mountPath, "roles", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseReadRoleResult.class));
    }

    public VaultRequest<VaultSecretsDatabaseListRolesResult> listRoles(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Roles")).path(mountPath, "roles").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseListRolesResult.class));
    }

    public VaultRequest<Void> deleteRole(String mountPath, String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Role")).path(mountPath, "roles", roleName).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsDatabaseGenerateCredentialsResult> generateCredentials(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Generate Credentials")).path(mountPath, "creds", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseGenerateCredentialsResult.class));
    }

    public VaultRequest<Void> updateStaticRole(String mountPath, String roleName, VaultSecretsDatabaseUpdateStaticRoleParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Static Role")).path(mountPath, "static-roles", roleName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsDatabaseReadStaticRoleResult> readStaticRole(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Static Role")).path(mountPath, "static-roles", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseReadStaticRoleResult.class));
    }

    public VaultRequest<VaultSecretsDatabaseListStaticRolesResult> listStaticRoles(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Static Roles")).path(mountPath, "static-roles").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseListStaticRolesResult.class));
    }

    public VaultRequest<Void> deleteStaticRole(String mountPath, String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Static Role")).path(mountPath, "static-roles", roleName).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsDatabaseGenerateStaticRoleCredentialsResult> generateStaticRoleCredentials(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Generate Static Role Credentials")).path(mountPath, "static-creds", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsDatabaseGenerateStaticRoleCredentialsResult.class));
    }

    public VaultRequest<Void> rotateStaticCredentials(String mountPath, String roleName) {
        return VaultRequest.post(this.getTraceOpName("Rotate Static Credentials")).path(mountPath, "rotate-role", roleName).expectNoContentStatus().build();
    }
}

